% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_api.R
\name{dawa}
\alias{dawa}
\title{Base API function}
\usage{
dawa(
  section,
  ...,
  append_to_url = NULL,
  format = NULL,
  verbose = TRUE,
  cache = TRUE,
  dry_run = FALSE,
  func_params = list()
)
}
\arguments{
\item{section}{Defines what section of the api should be called.
\code{available_sections()} exposes all options for this parameter.}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> input query parameters.}

\item{append_to_url}{This options enables you to append a string to the url.
It is inserted in the request after the \code{section} but before the \code{...}.}

\item{format}{The format to provide as a query parameter for the api call. By
default it has value \code{NULL} and triggers default json formatting. When
\code{geojson} or \code{geojsonz} is provided, the function will return the raw json
data instead of the usual list.}

\item{verbose}{whether or not to provide \code{{cli}} output for the user. Enabled
by default, but disabled for all functions that wrap this function}

\item{cache}{Option to use caching in a \code{tempdir()}. Enabled by default. More
info can be found in the documentation for \code{httr2::req_cache()}.}

\item{dry_run}{With this option enabled, the function will output the request
that has been created - Without sending it to the api. This is useful for
debugging.}

\item{func_params}{Option to include extra parameters (just like \code{...}
above). This option is used to pass down the dot-inputs from \code{get_data()}
and \code{get_map_data()}. It is recommended to use the dynamic dots instead of
this option, as an end user.}
}
\value{
By default returns the API response as a list output. For
\code{geojson(z)} formats it returns the raw json. When \code{dry_run = TRUE} it
returns the request that has been created but does not run it.
}
\description{
This function is the foundation of all communication with the
api in this package. Not intended for end-users, but it provides all the
flexibility of the api without the nice conveniences of the other functions
in this package. By default it reformats the api response (which is json)
to a list object.
}
\examples{
if (connection_check()) {
  x <- dawa(section = "sogne")

  x[[1]]
}
}
