% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_nd.r
\name{calc_nd}
\alias{calc_nd}
\title{Count days meeting set criteria}
\usage{
calc_nd(file, start_doy = 1, end_doy = 365, criteria, value,
  internal = FALSE, path = tempdir())
}
\arguments{
\item{file}{path of a file containing the daily gridded Daymet data}

\item{start_doy}{numeric day-of-year at which counting should begin. 
(default = 1)}

\item{end_doy}{numeric day of year at which counting should end. 
(default = 365)}

\item{criteria}{logical expression (">=",">","<=","<","==", "!=") to evaluate}

\item{value}{the value that the criteria is evaluated against}

\item{internal}{return to workspace (\code{TRUE}) or write to disk
(\code{FALSE}) (default = \code{FALSE})}

\item{path}{path to which to write data to disk (default = tempdir())}
}
\value{
A raster object in the R workspace or a file on disk with summary
statistics for every pixel which meet the predefined criteria. Output files
if written to file will be named nd_YYYY.tif (with YYYY the year of the
processed tile or ncss netCDF file).
}
\description{
Function to count the number of days in a given time period
that meet a given set of criteria. This can be used to extract indices 
such as Growing Degree Days (tmin > 0), or days with precipitation 
(prcp != 0).
}
\examples{

\dontrun{
# download daily gridded data
# using default settings (data written to tempdir())
download_daymet_ncss()

# read in the Daymet file and report back the number
# of days in a year with a minimum temperature lower
# than 15 degrees C
r <- calc_nd(file.path(tempdir(),"tmin_daily_1980_ncss.nc"),
            criteria = "<",
            value = 15,
            internal = TRUE)
            
# plot the output
raster::plot(r)
}
}
\keyword{Daymet,}
\keyword{gridded}
\keyword{series,}
\keyword{summary}
\keyword{time}
