% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbcsp.R
\name{plot.dbcsp}
\alias{plot.dbcsp}
\title{Plot function implemented by dbcsp class}
\usage{
\method{plot}{dbcsp}(x, class = 1, index = 1, vectors = 1:(x@q*2), pairs=TRUE,
     before = TRUE, after = TRUE, legend = FALSE, ...)
}
\arguments{
\item{x}{object of class \code{\link[=dbcsp-class]{dbcsp}}.}

\item{class}{integer, which of both classes to access (1 or 2), by default \code{class=1}}

\item{index}{an integer, representing which instance of the class to plot, by default \code{index=1}.}

\item{vectors}{an integer or vector of integers, representing the vectors to plot after the projection, by default all the vectors used in the projection are plotted \code{vectors=1:(x@q*2)}.}

\item{pairs}{logical, if TRUE the pairs of the indicated vectors are also shown, by default \code{pairs=TRUE}.}

\item{before}{logical, if TRUE the original signals are plotted, by default \code{before=TRUE}.}

\item{after}{logical, if TRUE the signals after projection are plotted, by default \code{after=TRUE}.}

\item{legend}{logical, if true the legend of the transformed signals is shown, by default \code{legend=FALSE}. When plotting more than 15 pairs of signals (15*2=30 signals), the legend is not shown. If \code{before=TRUE} legends are not displayed.}

\item{...}{optional arguments inherited from the generic \code{\link{plot}} method.}
}
\value{
Displays a plot of the selected instance before and/or after the DB-CSP filter projection.
The vectors shown after the projection are differentiated by the q first and q last vectors,
since the former maximize the variance of one class and minimize the variance of the other, while the latter do the opposite.
}
\description{
This function plots an instance before and/or after its DB-CSP projection.
}
\details{
It plots an instance before and/or after being projected with the DB-CSP filter.
Vectors values must lie between 1 and 2*q, being q the number of dimensions used to perform the DB-CSP
algorithm when creating the \code{\link[=dbcsp-class]{dbcsp}} object. The following should be
taken into account when plotting:
\itemize{
\item The first q values (1,...,q) are indicated as a1...aq, and are plotted with solid lines.
\item The last q values (q+1,...,2*q) are indicated as b1...bq, and are plotted with dashed lines.
}

If \code{pairs=TRUE}, it is recommended that \code{vectors<q} for better understanding,
since their pairs are plotted as well. In case that \code{vectors>q}, it should be noted
that the values are displayed from b1 to bq, where b1 and bq represent q+1 vector and 2*q vector,
respectively. The paired vectors (a1-b1, a2-b2, ...) are plotted with the same color, but different line type.

For example if \code{q=15} and \code{plot(object, vectors=16, pairs=FALSE)}, b1 (16-q=1) vector is
shown.
}
\examples{
# Read data from 2 classes
x <- AR.data$come
y <- AR.data$five
mydbcsp <- new("dbcsp", X1 = x, X2 = y)
plot(mydbcsp)
plot(mydbcsp,class=2,index=30,vectors=1:5,before=FALSE, legend=TRUE)
}
\seealso{
\code{\link[=dbcsp-class]{dbcsp}}, \code{\link[=print.dbcsp]{print}}, \code{\link[=summary.dbcsp]{summary}}, \code{\link{train}}, \code{\link{selectQ}}, \code{\link[=predict.dbcsp]{predict}}, \code{\link[=boxplot.dbcsp]{boxplot}}
}
