% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ident.R
\name{ident}
\alias{ident}
\alias{ident_q}
\alias{is.ident}
\title{Flag a character vector as SQL identifiers}
\usage{
ident(...)

ident_q(...)

is.ident(x)
}
\arguments{
\item{...}{A character vector, or name-value pairs}

\item{x}{An object}
}
\description{
\code{ident()} takes unquoted strings and flags them as identifiers.
\code{ident_q()} assumes its input has already been quoted, and ensures
it does not get quoted again. This is currently used only for
for \code{schema.table}.
}
\examples{
# SQL92 quotes strings with '
escape_ansi("x")

# And identifiers with "
ident("x")
escape_ansi(ident("x"))

# You can supply multiple inputs
ident(a = "x", b = "y")
ident_q(a = "x", b = "y")
}
