% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend-redshift.R
\name{backend-redshift}
\alias{simulate_redshift}
\title{Backend: Redshift}
\usage{
simulate_redshift()
}
\description{
Base translations come from \link[=simulate_postgres]{PostgreSQL backend}. There
are generally few differences, apart from string manipulation.

Use \code{simulate_redshift()} with \code{lazy_frame()} to see simulated SQL without
converting to live access database.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

lf <- lazy_frame(a = TRUE, b = 1, c = 2, d = "z", con = simulate_redshift())
lf \%>\% transmute(x = paste(c, " times"))
lf \%>\% transmute(x = substr(c, 2, 3))
lf \%>\% transmute(x = str_replace_all(c, "a", "z"))
}
