% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate-sql-window.R, R/backend-teradata.R
\name{win_over}
\alias{win_over}
\alias{win_rank}
\alias{win_aggregate}
\alias{win_aggregate_2}
\alias{win_recycled}
\alias{win_cumulative}
\alias{win_absent}
\alias{win_current_group}
\alias{win_current_order}
\alias{win_current_frame}
\alias{win_rank_tdata}
\title{Generate SQL expression for window functions}
\usage{
win_over(
  expr,
  partition = NULL,
  order = NULL,
  frame = NULL,
  con = sql_current_con()
)

win_rank(f)

win_aggregate(f)

win_aggregate_2(f)

win_cumulative(f)

win_absent(f)

win_current_group()

win_current_order()

win_current_frame()

win_rank_tdata(f)
}
\arguments{
\item{expr}{The window expression}

\item{partition}{Variables to partition over}

\item{order}{Variables to order by}

\item{frame}{A numeric vector of length two defining the frame.}

\item{f}{The name of an sql function as a string}
}
\description{
\code{win_over()} makes it easy to generate the window function specification.
\code{win_absent()}, \code{win_rank()}, \code{win_aggregate()}, and \code{win_cumulative()}
provide helpers for constructing common types of window functions.
\code{win_current_group()} and \code{win_current_order()} allow you to access
the grouping and order context set up by \code{\link[=group_by]{group_by()}} and \code{\link[=arrange]{arrange()}}.
}
\examples{
con <- simulate_dbi()

win_over(sql("avg(x)"), con = con)
win_over(sql("avg(x)"), "y", con = con)
win_over(sql("avg(x)"), order = "y", con = con)
win_over(sql("avg(x)"), order = c("x", "y"), con = con)
win_over(sql("avg(x)"), frame = c(-Inf, 0), order = "y", con = con)
}
\keyword{internal}
