% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/cpmg.R
\docType{methods}
\name{T2.fast}
\alias{T2.fast}
\alias{T2.fast,anlz-method}
\alias{T2.fast,array-method}
\alias{T2.fast,nifti-method}
\alias{T2.lm}
\title{Quantitative T2 Methods}
\usage{
T2.fast(cpmg, ...)

\S4method{T2.fast}{array}(cpmg, cpmg.mask, TE,
  control = minpack.lm::nls.lm.control(maxiter = 150), multicore = FALSE,
  verbose = FALSE)

T2.lm(signal, TE, guess, control = minpack.lm::nls.lm.control())
}
\arguments{
\item{cpmg}{is a multidimensional array of signal intensities.  The last
dimension is assumed to be a function of the echo times, while the previous
dimenions are assued to be spatial.}

\item{...}{Additional variables defined by the method.}

\item{cpmg.mask}{is a (logical) multidimensional array that identifies the
voxels to be analyzed.}

\item{TE}{is the vector of echo times (in seconds).}

\item{control}{An optional list of control settings for \code{nls.lm}.  See
\code{nls.lm.control} for the names of the settable control values and their
effect.}

\item{multicore}{is a logical variable (default = \code{FALSE}) that allows
parallel processing via \pkg{multicore}.}

\item{verbose}{is a logical variable (default = \code{FALSE}) that allows
text-based feedback during execution of the function.}

\item{signal}{is the vector of signal intensities as a function of echo
times.}

\item{guess}{is the vector of initial values for the parameters of interest:
\eqn{\rho}{rho} and \eqn{T2}{T2}.}
}
\value{
A list structure is produced with (all or some of the) parameter
estimates
\item{rho}{Scaling factor between signal intensity and T2 (proton density).}
\item{T2}{T2 relaxation time.}
}
\description{
The regional blood volume is found by integrating of the tissue concentration
curve and the artieral input funciton (AIF).  In order to avoid reperfusion
effects on the rCBV measurements, the tissue and arteiral concentration
curves must first be reduced to their first-pass versions.
}
\author{
Brandon Whitcher \email{bwhitcher@gmail.com}
}
\references{
Kennan, R.P. and J\"ager, H.R. (2004) $T_2$- and $T_2^*$-w DCE-MRI: Blood
Perfusion and Volume Estimation using Bolus Tracking, in \emph{Quantiative
MRI of the Brain} (P. Tofts ed.), Wiley: Chichester, UK, pp. 365-412.
}
\seealso{
\code{\link{R1.fast}}, \code{\link{R10.lm}}
}
\keyword{misc}

