% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type-wildtype_mutant_pnpp.R
\name{plot.wildtype_mutant_pnpp}
\alias{plot.wildtype_mutant_pnpp}
\title{Plot a ddPCR plate of type wildtype/mutant PNPP}
\usage{
\method{plot}{wildtype_mutant_pnpp}(
  x,
  wells,
  samples,
  ...,
  col_drops_mutant = "purple3",
  col_drops_wildtype = "green3",
  col_drops_rain = "black",
  show_mutant_freq = TRUE,
  text_size_mutant_freq = 4,
  alpha_drops_low_mutant_freq = 0.5,
  show_low_high_mut_freq = TRUE,
  bg_mutant = "purple3",
  bg_wildtype = "green3",
  alpha_bg_low_high_mut_freq = 0.1
)
}
\arguments{
\item{x}{A ddPCR plate.}

\item{wells}{Only plot selected wells. Supports range notation, see
\code{\link[ddpcr]{subset.ddpcr_plate}}.}

\item{samples}{Only plot selected samples.}

\item{...}{Parameters to pass to \code{\link[ddpcr]{plot.pnpp_experiment}}.}

\item{col_drops_mutant}{The colour to use for mutant droplets.}

\item{col_drops_wildtype}{The colour to use for wildtype droplets.}

\item{col_drops_rain}{The colour to use for rain droplets.}

\item{show_mutant_freq}{If \code{TRUE}, show the mutant frequency
as a percentage on each well.}

\item{text_size_mutant_freq}{Text size of the printed mutant frequencies.}

\item{alpha_drops_low_mutant_freq}{Transparency of mutant droplets
in wells with mostly wildtype droplets. In wells where there are very few
mutant droplets, it might be useful to make them more visible by increasing
their transparency.}

\item{show_low_high_mut_freq}{Differentiate between wells with a high vs
low mutant frequency by having a different background colour to the well.}

\item{bg_mutant}{The background colour for wells that have a significant
mutant cluster.}

\item{bg_wildtype}{The background colour for wells that have mostly wildtype
drops.}

\item{alpha_bg_low_high_mut_freq}{The transparency value for \code{bg_mutant}
and \code{bg_wildtype}.}
}
\value{
A ggplot2 plot object.
}
\description{
Same plot as \code{\link[ddpcr]{plot.pnpp_experiment}} but with a few extra
features that are specific to wildtype/mutant PNPP plates. Take a look
at \code{\link[ddpcr]{plot.pnpp_experiment}} to see all supported parameters
and more information.
}
\examples{
\dontrun{
plate <- new_plate(sample_data_dir(), type = plate_types$fam_positive_pnpp) \%>\% analyze
wells_wildtype(plate)
plot(plate)
plate <- plate \%>\% analyze
plot(plate)
plot(plate, "A01:C05", col_drops_rain = "blue")
}
}
\seealso{
\code{\link[ddpcr]{plot.ddpcr_plate}}\cr
\code{\link[ddpcr]{plot.pnpp_experiment}}\cr
\code{\link[ddpcr]{wildtype_mutant_pnpp}}
}
