% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mddsPLS.R
\name{MddsPLS_core}
\alias{MddsPLS_core}
\title{The core function of the Multi-Data-Driven sparse PLS function.}
\usage{
MddsPLS_core(Xs, Y, lambda = 0, R = 1, mode = "reg", L0 = NULL,
  mu = NULL, deflat = FALSE, weight = FALSE, id_na = NULL,
  NZV = 1e-09)
}
\arguments{
\item{Xs}{A matrix, if there is only one block, or a list of matrices,, if there is more than one block, of \strong{n} rows each, the number of individuals. Some rows must be missing. The different matrices can have different numbers of columns. The length of Xs is denoted by \strong{K}.}

\item{Y}{A matrix of n rows of a vector of length n detailing the response matrix. No missing values are allowed in that matrix.}

\item{lambda}{A real \eqn{[0,1]} where 1 means just perfect correlations will be used and 0 no regularization is used.}

\item{R}{A strictly positive integer detailing the number of components to build in the model.}

\item{mode}{A character chain. Possibilities are "\strong{(reg,lda,logit)}", which implies regression problem, linear discriminant analysis (through the paclkage \code{MASS}, function \code{lda}) and logistic regression (function \code{glm}). Default is \strong{reg}.}

\item{L0}{An integer non nul parameter giving the largest number of X variables that can be selected.}

\item{mu}{A real positive. The Ridge parameter changing the bias of the regression model. If is NULL, consider the classical ddsPLS. Default to NULL.}

\item{deflat}{Logical. If TRUE, the solution uses deflations to construct the weights.}

\item{weight}{Logical. If TRUE, the scores are divided by the number of selected variables in the corresponding block.}

\item{id_na}{A list of na indices for each block. Initialized to NULL.}

\item{NZV}{Float. The floatting value above which the weights are set to 0.}
}
\value{
A list containing the following objects:
\describe{
  \item{u}{A list of length \strong{K}. Each element is a \strong{p_kXR} matrix : the
   weights per block per axis.}
  \item{u_t_super}{A list of length \strong{K}. Each element is a \strong{p_kXR} matrix : the
   weights per block per axis scaled on the super description of the data set. Denoted as
   \strong{scaled super-weights}.}
  \item{v}{A \strong{qXR} matrix : the weights for the \strong{Y} part.}
  \item{ts}{A list of length \strong{R}. Each element is a \strong{nXK} matrix : the
   scores per axis per block.}
  \item{(t,s)}{Two \strong{nXR} matrices, super-scores of the \strong{X} and \strong{Y} parts.}
  \item{(t_ort,s_ort)}{Two \strong{nXR} matrices, final scores of the \strong{X} and \strong{Y} part.
   They correspond to \strong{PLS} scores of \strong{(t,s)} scores and so \strong{t_ort^T s_ort} is diagonal,
   \strong{t_ort}, respectively \strong{s_ort}, carries the same information as \strong{t}, respectively \strong{s}.}
  \item{B}{A list of length \strong{K}. Each element is a \strong{p_kXq} matrix : the
   regression matrix per block.}
  \item{(mu_x_s,sd_x_s)}{Two lists of length \strong{K}. Each element is a \strong{p_k} vector : the
   mean and standard deviation variables per block.}
  \item{(mu_y,sd_y)}{Two vectors of length \strong{q} : the mean and the standard deviation variables for \strong{Y} part.}
  \item{R}{Given as an input.}
  \item{q}{A non negative integer : the number of variables of \strong{Y} matrix. }
  \item{Ms}{A list of length \strong{K}. Each element is a \strong{qXp_k} matrix : the
   soft-thresholded empirical variance-covariance matrix \eqn{Y^TX_k/(n-1)}.}
  \item{lambda}{Given as an input.}
}
}
\description{
This function should not be used directly by the user.
}
