% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bifurcation.R
\name{bifurcation}
\alias{bifurcation}
\title{Phaseplane analysis of a system of ODEs}
\usage{
bifurcation(model, state, parms, resume = TRUE, ...)
}
\arguments{
\item{model}{(function, required)
\preformatted{}
              An R-function that computes the values of the derivatives
              in the ODE system (the model definition) at time t.
              The model must be defined as: model <- function(t, state, parms),
              where t is the current time point in the integration, state is
              the current value of the variables in the ODE #' system and
              parms is a vector or list of parameters.
              The return value of func should be a list, whose first and single
              element is a vector containing the derivatives of y with respect
              to time. The derivatives must be specified in the same order as
              the state variables state. The vector state and parms should both
              have name attributes for all their elements}

\item{state}{(numeric vector, required)
\preformatted{}
              The initial (state) values for the ODE system. This vector should
              have name attributes for all its elements}

\item{parms}{(numeric vector, required)
\preformatted{}
              The values of the parameters in the ODE system. This vector should
              have name attributes for all its elements}

\item{resume}{(boolean, optional)
\preformatted{}
              If TRUE the program will try to load the curves computed during
              the last session from the global variable '<model>BifCurves' and try
              to restore the numerical and plot settings by importing them from
              the global variable '<model>BifSettings', where the substring
              '<model>' is the name of the function describing the dynamics, which
              is passed as first argument to 'bifurcation()'.
              The program saves the curves computed during a session and the
              numerical and plot settings of this last session in these global
              variables '<model>BifCurves' and '<model>BifSettings'.}

\item{...}{(optional arguments)
\preformatted{}
              Additional arguments that can be included at the command line to tweak
              graphical default values used by the application.
              Valid arguments are:
\preformatted{}
              \code{lwd}:         Line width (default 3)
\preformatted{}
              \code{cex}:         Base font size (default 1.2)
\preformatted{}
              \code{tcl.len}:     Length of axes ticks (default 0.03)
\preformatted{}
              \code{bifsym}:      Symbol used to mark a bifurcation point
                                    in an equilibrium curve (default: 8)
\preformatted{}
              \code{biflblpos}:   Location of label of a bifurcation point. Values
                                  of 1, 2, 3 and 4, respectively, indicate positions
                                  below, to the left of, above and to the right of
                                  the symbol marking the bifurcation point (default: 3)
\preformatted{}
              \code{unstablelty}: Line style of curve section representing unstable
                                  equilibrium points (default: 3 (refers to dotted lines))

\preformatted{}
              \code{saveplotas}:  Possible values: "pdf" or "png" (default).
                                  Save plot to PDF or PNG file.}
}
\value{
None.
}
\description{
\code{bifurcation}
}
\details{
bifurcation(model, state, parms, resume = TRUE, ...)
}
\examples{
if(interactive()){
# The initial state of the system has to be specified as a named vector of state values.
state <- c(R=1, N=0.01)

# Parameters has to be specified as a named vector of parameters.
parms <- c(r=1, K=1, a=1, c=1, delta=0.5)

# The model has to be specified as a function that returns
# the derivatives as a list.
model <- function(t, state, parms) {
  with(as.list(c(state,parms)), {

    dR <- r*R*(1 - R/K) - a*R*N
    dN <- c*a*R*N - delta*N

   # The order of the derivatives in the returned list has to be
   # identical to the order of the state variables contained in
   # the argument "state"
    return(list(c(dR, dN)))
  })
}

bifurcation(model, state, parms)
}
}
