% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_sets.R
\docType{data}
\name{Electric_plants}
\alias{Electric_plants}
\title{Data: Färe, Grosskopf and Kokkelenberg (1989).}
\format{Data frame with 18 rows and 5 columns. Definition of inputs (X) and outputs (Y):
\describe{
  \item{x1 = Labor}{Labor average annual employment}
  \item{x2 = Fuel}{Fuel \eqn{10^{10}} Btu}
  \item{x3 = Capital}{Capital MW (fixed input)}
  \item{y1 = Output}{Output \eqn{10^6} Kwh}
}}
\source{
Färe, R.; Grosskopf, S.; Kokkenlenberg, E. (1989). "Measuring Plant Capacity, Utilization and Technical Change: A Nonparametric Approach". International Economic Review, 30(3), 655-666.

Simar, L.; Wilson, P.W. (1998). "Sensitivity Analysis of Efficiency Scores: How to Bootstrap in Nonparametric Frontier Models". Management Science, 44(1), 49-61.
}
\usage{
data("Electric_plants")
}
\description{
Data of 19 coal-fired steam-electric generating plants operating in Illinois in 1978. Each plant uses 3 inputs to produce 1 output.
}
\examples{
# Example. Replication of results in Simar and Wilson (1998, p.59)
data("Electric_plants")
data_example <- read_data(Electric_plants,
                          dmus = 1,
                          ni=3,
                          no=1)
result <- model_basic(data_example,
                      orientation="io",
                      rts="vrs")
efficiencies(result)

}
\seealso{
\code{\link{read_data}}, \code{\link{model_basic}}
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolos} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benitez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
\keyword{datasets}
