% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate1d.R
\name{estimate1d}
\alias{as.estimate1d}
\alias{estimate1d}
\title{Create a 1-dimensional estimate object.}
\usage{
estimate1d(distribution, lower, upper, ...)

as.estimate1d(x, ...)
}
\arguments{
\item{distribution}{\code{character}: A character string that defines the type of the univariate
parametric distribution.}

\item{lower}{\code{numeric}: lower bound of the 90\% confidence interval, i.e the 5\%-quantile 
of this estimate.}

\item{upper}{\code{numeric}: upper bound of the 90\% confidence interval, i.e the 95\%-quantile 
of this estimate.}

\item{...}{arguments that can be coerced to a list comprising further elements of the 1-d 
estimate (for details cf. below). Each element must be atomic and of length 1 (1-d property).}

\item{x}{an object to be transformed to class \code{estimate1d}.}
}
\value{
An object of class \code{estimate1d} and \code{list} with at least (!) the elements:
   \tabular{lll}{
     \bold{Element}      \tab  \bold{R-type}                 \tab \bold{Explanation}\cr
     \code{distribution} \tab  \code{character}              \tab  Distribution type of the estimate \cr
     \code{lower}        \tab  \code{numeric}                \tab   5\%-quantile of the estimate\cr
     \code{median}       \tab  \code{numeric} or \code{NULL} \tab  50\%-quantile of the estimate\cr
     \code{upper}        \tab  \code{numeric}                \tab  95\%-quantile of the estimate
   }
   Note that the \emph{\code{median}} is a mandatory element of an \code{estimate1d}, although it
    is not necessary as input. If \code{median} is numeric it holds that:
   \code{lower <= median <= upper}. In any case an \code{estimate1d} object has the property 
   \code{lower <= upper}.
}
\description{
\code{estimate1d} creates an object of class \code{estimate1d}. The estimate of a one dimensional
variable is at minimum defined by the type of a univariate parametric distribution, the 5\% - and
95\% quantiles. Optionally, the median can be supplied.

\code{as.estimate1d} tries to transform an object to class \code{estimate1d}.
}
\details{
It must hold that \code{lower <= upper}.
  \subsection{The structure of the input arguments}{
    \subsection{Mandatory input elements}{
    \tabular{lll}{
      \bold{Argument}    \tab  \bold{R-type}     \tab \bold{Explanation}\cr
      \code{distribution} \tab  \code{character} \tab  Distribution type of the estimate \cr
      \code{lower}        \tab  \code{numeric}   \tab   5\%-quantile of the estimate\cr
      \code{upper}        \tab  \code{numeric}   \tab  95\%-quantile of the estimate
    }
    }
    \subsection{Optional input elements}{
    The optional parameters in \code{...} provide additional characteristics of the 1-d estimate. 
    Frequent optional elements are:
    \tabular{lll}{
      \bold{Argument}     \tab  \bold{R-type}                 \tab \bold{Explanation}\cr
      \code{variable}     \tab  \code{character}              \tab  Variable name\cr
      \code{median}       \tab  cf. below                     \tab  50\%-quantile of the estimate\cr
      \code{method}       \tab  \code{character}              \tab  Method for calculation of distribution parameters
   }
   \subsection{The \code{median}}{
     If supplied as input, \code{median} can be either \code{NULL},  \code{numeric} or the
     character string \code{"mean"}. If it is \code{NA} it is set to \code{NULL}; if it equals
     \code{"mean"} it is set to \code{mean(c(lower, upper))}; if it is \code{numeric} it must 
     hold that \code{lower <= median <= upper}. 
     In case that no element \code{median} is provided, the default is \code{median=NULL}. 
   }    
   }
 }
}
\seealso{
\code{\link{random.estimate1d}}
}

