% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cost_functions.R
\name{wmultinomial}
\alias{wmultinomial}
\title{wmultinomial function}
\usage{
wmultinomial(w, batchsize)
}
\arguments{
\item{w}{a vector of weights, adding up whose length is equal to the output length of the net}

\item{batchsize}{of batch used in inference WARNING: ensure this matches with actual batchsize used!}
}
\value{
a list object with elements that are functions, evaluating the loss and the derivative
}
\description{
A function to evaluate the weighted multinomial loss function and the derivative of this function
to be used when training a neural network. This is eqivalent to a multinomial cost function
employing a Dirichlet prior on the probabilities. Its effect is to regularise the estimation so
that in the case where we apriori expect more of one particular category compared to another
then this can be included in the objective.
}
\references{
\enumerate{
    \item Ian Goodfellow, Yoshua Bengio, Aaron Courville, Francis Bach. Deep Learning. (2016)
    \item Terrence J. Sejnowski. The Deep Learning Revolution (The MIT Press). (2018)
    \item Neural Networks YouTube playlist by 3brown1blue: \url{https://www.youtube.com/playlist?list=PLZHQObOWTQDNU6R1_67000Dx_ZCJB-3pi}
    \item{http://neuralnetworksanddeeplearning.com/}
}
}
\seealso{
\link{network}, \link{train}, \link{backprop_evaluate}, \link{MLP_net}, \link{backpropagation_MLP},
\link{Qloss}, \link{no_regularisation}, \link{L1_regularisation}, \link{L2_regularisation}
}
