% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_design.R
\name{ALC}
\alias{ALC}
\alias{ALC.gp}
\alias{ALC.dgp2}
\alias{ALC.dgp3}
\title{Active Learning Cohn for Sequential Design}
\usage{
ALC(object, x_new, ref, cores)

\method{ALC}{gp}(object, x_new = NULL, ref = NULL, cores = 1)

\method{ALC}{dgp2}(object, x_new = NULL, ref = NULL, cores = 1)

\method{ALC}{dgp3}(object, x_new = NULL, ref = NULL, cores = 1)
}
\arguments{
\item{object}{object of class \code{gp}, \code{dgp2}, or \code{dgp3}}

\item{x_new}{matrix of possible input locations, if object has been run 
through \code{predict} the previously stored \code{x_new} is used}

\item{ref}{optional reference grid for ALC approximation, if \code{ref = NULL} 
then \code{x_new} is used}

\item{cores}{number of cores to utilize in parallel, by default no 
parallelization is used}
}
\value{
list with elements:
\itemize{
  \item \code{value}: vector of ALC values, indices correspond to \code{x_new}
  \item \code{time}: computation time in seconds
}
}
\description{
Acts on a \code{gp}, \code{dgp2}, or \code{dgp3} object. 
   Current version requires squared exponential covariance 
   (\code{cov = "exp2"}).  Calculates ALC over the input locations 
   \code{x_new} using specified reference grid.  If no reference grid is 
   specified, \code{x_new} is used as the reference.  Optionally utilizes 
   SNOW parallelization.  User should 
   select the point with the highest ALC to add to the design.
}
\details{
All iterations in the object are used in the calculation, so samples 
    should be burned-in.  Thinning the samples using \code{trim} will
    speed up computation.  This function may be used in two ways:
    \itemize{
        \item Option 1: called on an object with only MCMC iterations, in 
              which case \code{x_new} must be specified
        \item Option 2: called on an object that has been predicted over, in 
              which case the \code{x_new} from \code{predict} is used
    }
    In Option 2,  it is recommended to set \code{store_latent = TRUE} for 
    \code{dgp2} and \code{dgp3} objects so
    latent mappings do not have to be re-calculated.  Through \code{predict}, 
    the user may specify a mean mapping (\code{mean_map = TRUE}) or a full 
    sample from the MVN distribution over \code{w_new} 
    (\code{mean_map = FALSE}).  When the object has not yet been predicted
    over (Option 1), the mean mapping is used.
    
    SNOW parallelization reduces computation time but requires more memory
    storage.  C code derived from the "laGP" package (Robert B Gramacy and 
    Furong Sun).
}
\examples{
# See "deepgp-package" or "fit_two_layer" for an example

}
\references{
Sauer, A, RB Gramacy, and D Higdon. 2020. "Active Learning for Deep Gaussian 
    Process Surrogates." \emph{Technometrics, to appear;} arXiv:2012.08015. 
    \cr\cr
Seo, S, M Wallat, T Graepel, and K Obermayer. 2000. Gaussian Process Regression:
    Active Data Selection and Test Point Rejection. In Mustererkennung 2000, 
    2734. New York, NY: SpringerVerlag.\cr\cr
Gramacy, RB and F Sun. (2016). laGP: Large-Scale Spatial Modeling via Local 
    Approximate Gaussian Processes in R. \emph{Journal of Statistical Software 
    72} (1), 1-46. doi:10.18637/jss.v072.i01
}
