% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to.R
\name{toSpanish}
\alias{toSpanish}
\title{Translate a text into Spanish with the DeepL Translator API}
\usage{
toSpanish(text, source_lang = NULL, tag_handling = NULL,
  split_sentences = TRUE, preserve_formatting = FALSE, get_detect = FALSE,
  auth_key = "your_key")
}
\arguments{
\item{text}{text to be translated. Only UTF8-encoded plain text is supported. May contain multiple sentences.
The request size should not exceed 30kbytes.}

\item{source_lang}{language of the text to be translated. Can be one of the following:
\itemize{
\item \code{EN} English
\item \code{DE} German
\item \code{FR} French
\item \code{IT} Italian
\item \code{NL} Dutch
\item \code{PL} Polish
 }
    If parameter \code{is.null}, the API will detect the language of the text and translate it.}

\item{tag_handling}{if set to \code{"xml"}, the translation engine tries to find matches for XML enclosed words in
the translated sentence and enclose them with the same tags. If no matching words are found, the tags are removed.}

\item{split_sentences}{if \code{TRUE}, the translation engine splits the input into sentences. If only one sentence
is translated, it is recommended to set to \code{FALSE} to prevent the engine from unintentionally splitting the sentence.}

\item{preserve_formatting}{if \code{TRUE}, the translation engine tries to preserve some aspects (e.g. punctuation at the beginning
and end of the sentence, upper/lower case at the beginning of the sentence) of the formatting.}

\item{get_detect}{if \code{TRUE}, the language detected for the source text is also inclued in the response. It corresponds to
the value of the argument \code{source_lang} if it was specified. If \code{FALSE}, only the translated text is returned.}

\item{auth_key}{your \code{DeepL} authentication key which provides access to the API.}
}
\value{
If \code{get_detect} is set to \code{FALSE} a \code{character vector} containing the translation is returned. Otherwise,
   a \code{data.frame} (\code{tibble::tibble}) is returned with the following columns:
\itemize{
\item \code{translation} the translated text.
\item \code{source_lang} detected or specified language of the input text.
}
}
\description{
\code{toSpanish} calls the \code{DeepL} translator API and translates a text from English, German,
    French, Italian, Dutch or Polish into Spanish.
}
\details{
To get an authentication key, you need to register for a DeepL Pro account (\url{https://www.deepl.com/pro.html}).
    This currently costs 20 euros per month and allows the translation of 1,000,000 characters per month (see
    \url{https://www.deepl.com/pro-pricing.html}).
}
\examples{
\donttest{
# Simple translation
toSpanish("Hallo Welt!", auth_key = "my_key")

# Customized translator applied to multiple strings
txt1 <- c("My name is Albert.", "I'm a physicist.", "I was born in 1879 in Ulm.")
translator1 <- function(t) toSpanish(text = t, auth_key = "x")
purrr::map_chr(txt1, translator1)

# Customized translator applied to multiple strings (with language detection response)
txt2 <- c("Je m'appelle Jean.", "Ich bin Arzt.", "I'm from Wales")
translator2 <- function(t) toSpanish(text = t, get_detect = T, auth_key = "x")
purrr::map_df(txt2, translator2)

}


}
\references{
\href{https://www.deepl.com/api.html}{DeepL API documentations}
}
