% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_lang2.R
\name{toEnglish2}
\alias{toEnglish2}
\title{Translate texts into English using DeepL}
\usage{
toEnglish2(text, source_lang = NULL, get_detect = FALSE)
}
\arguments{
\item{text}{text to be translated. Must not exceed 5000 characters. Only UTF8-encoded plain text is supported.
May contain multiple sentences.}

\item{source_lang}{language of the text to be translated. Can be one of the following:
\itemize{
\item \code{DE} German
\item \code{FR} French
\item \code{ES} Spanish
\item \code{IT} Italian
\item \code{NL} Dutch
\item \code{PL} Polish
 }
    If parameter \code{is.null}, the API will try to detect the language of the text.}

\item{get_detect}{if \code{TRUE}, the language detected for the source text is also inclued in the response. It corresponds to
the value of the argument \code{source_lang} if it was specified. If \code{FALSE}, only the translated text is returned.}
}
\value{
If \code{get_detect} is set to \code{FALSE} a \code{character vector} containing the translation
    is returned. Otherwise, a \code{data.frame} (\code{tibble::tibble}) is returned with the following columns:
\itemize{
\item \code{translation} the translated text(s).
\item \code{source_lang} detected or specified language of the input text.
}
}
\description{
\code{toEnglish2} translates a text from German, French, Spanish, Italian, Dutch or Polish into English
    using the undocumented JSON-RPC DeepL API. No authentication key is required to use this service.
}
\examples{
\donttest{
# Simple translation
toEnglish2("Hallo Welt!")

# Customized translator applied to multiple strings
txt1 <- c("Mein Name ist Albert.", "Ich bin Physiker.", "Ich wurde 1879 in Ulm geboren.")
purrr::map_chr(txt1, toEnglish2)

# Customized translator applied to multiple strings (with language detection response)
txt2 <- c("Me llamo Fred.", "Je suis médecin.", "Ich komme aus der Schweiz.")
translator2 <- function(t) toEnglish2(text = t, get_detect = T)
purrr::map_df(txt2, translator2)

}


}
