% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valentesns.R
\docType{data}
\name{valentesns}
\alias{valentesns}
\alias{valentesnsList}
\title{Valente's SNS data}
\format{
The \code{valentesns} dataset has 1,722 records for 568 individuals, featuring the
following 18 columns:
\itemize{
\item \code{id}: Id of the individual.
\item \code{year}: Wave number.
\item \code{Hispanic}: Indicator variable equal to 1 if the individual is Hispanic.
\item \code{Female}: Indicator variable equal to 1 if the individual is female.
\item \code{Grades}: Academic grades ranging from 1 (mostly F) to 5 (mostly As).
\item \code{tobacco}: Indicator variable if the individual ever smoked tobacco.
\item \code{alcohol}: Indicator variable if the individual ever drink alcohol.
\item \code{mj}: : Indicator variable if the individual ever smoked marijuana.
\item \code{sibsmoke} : Indicator variable if the individual's sibling smokes.
\item \code{sibdrink}: Indicator variable if the individual's sibling drinks alcohol.
\item \code{adultdrink}: Indicator variable equal to one if there's an adult who
drinks in the household.
\item \code{year_value}: Year of the survey.
\item \code{present}: Indicator variable equal to 1 if the individual was present.
\item \code{school}: School id.
\item \code{has_sib}: Indicator variable equal to 1 if the individual has siblings.
\item \code{exposure_smoke}: Proportion of friends who have smoked tobacco in the
past.
\item \code{exposure_drink}: Proportion of friends who have drink alcohol in the
past.
\item \code{exposure_mj}: Proportion of friends who have smoked marijuana in the
past.
}

Exposure variables are marked with -1 for each individuals' first wave.
}
\source{
Valente, T. W., Fujimoto, K., Unger, J. B., Soto, D. W., & Meeker, D. (2013). Variations in network boundary and type: A study of adolescent peer influences. Social Networks, 35(3), 309–316. \url{doi:10.1016/j.socnet.2013.02.008}.
}
\usage{
valentesns
}
\description{
This dataset contains the data used in Valente et al. (2013) to study the
influence of peers on adolescent smoking, drinking, and marijuana use. The
\code{valentesnsList} is a transformed version of the data ready to be used to
create defm objects.
}
\keyword{datasets}
