/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.util.Iterator;
import java.util.Set;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.graph.Subgraph;

public class UndirectedSubgraph<V, E>
extends Subgraph<V, E, UndirectedGraph<V, E>>
implements UndirectedGraph<V, E> {
    private static final long serialVersionUID = 3256728359772631350L;

    public UndirectedSubgraph(UndirectedGraph<V, E> base, Set<? extends V> vertexSubset, Set<? extends E> edgeSubset) {
        super(base, vertexSubset, edgeSubset);
    }

    public UndirectedSubgraph(UndirectedGraph<V, E> base, Set<? extends V> vertexSubset) {
        this((UndirectedGraph<? extends V, E>)base, vertexSubset, (Set<E>)null);
    }

    public UndirectedSubgraph(UndirectedGraph<V, E> base) {
        this(base, (Set<V>)null, (Set<E>)null);
    }

    @Override
    public int degreeOf(V vertex) {
        this.assertVertexExist(vertex);
        int degree = 0;
        Iterator it = ((UndirectedGraph)this.base).edgesOf(vertex).stream().filter(e -> this.edgeSet.contains(e)).iterator();
        while (it.hasNext()) {
            Object e2 = it.next();
            ++degree;
            if (!this.getEdgeSource(e2).equals(this.getEdgeTarget(e2))) continue;
            ++degree;
        }
        return degree;
    }
}

