% Generated by roxygen2 (4.0.1): do not edit by hand
\name{assign_values_to_branches_edgePar}
\alias{assign_values_to_branches_edgePar}
\title{Assign values to edgePar of dendrogram's branches}
\usage{
assign_values_to_branches_edgePar(object, value, edgePar, skip_leaves = FALSE,
  warn = TRUE, ...)
}
\arguments{
\item{object}{a dendrogram object}

\item{value}{a new value scalar for the edgePar attribute.}

\item{edgePar}{the value inside edgePar to adjust.}

\item{skip_leaves}{logical (FALSE) - should the leaves be skipped/ignored?}

\item{warn}{logical (TRUE). Should warning be issued?
Generally, it is safer to keep this at TRUe.
But for specific uses it might be more user-friendly
to turn it off (for example, in the \link{tanglegram}
function)}

\item{...}{not used}
}
\value{
A dendrogram, after adjusting the edgePar attribute in all of its branches,
}
\description{
Go through the dendrogram branches and updates the values inside its edgePar

If the value has NA then the value in edgePar will not be changed.
(it could have also been something like NULL or Inf,
but for now it is only NA)
}
\examples{
\dontrun{

dend <- USArrests[1:5,] \%>\% dist \%>\% hclust \%>\% as.dendrogram
plot(dend)
dend <- assign_values_to_branches_edgePar(object=dend, value = 2, edgePar = "lwd")
plot(dend)
dend <- assign_values_to_branches_edgePar(object=dend, value = 2, edgePar = "col")
plot(dend)
dend <- assign_values_to_branches_edgePar(object=dend, value = 2, edgePar = "lty")
plot(dend)

}
}
\seealso{
\link{get_branches_attr}
}

