% Generated by roxygen2 (4.0.1): do not edit by hand
\name{get_nodes_attr}
\alias{get_nodes_attr}
\title{Get attributes of dendrogram's nodes}
\source{
Heavily inspired by the code in the
function \code{labels.dendrogram},
so credit should go to Martin Maechler.
}
\usage{
get_nodes_attr(object, attribute, include_leaves = TRUE,
  include_branches = TRUE, na.rm = FALSE, ...)
}
\arguments{
\item{object}{a dendrogram object}

\item{attribute}{character scalar of the attribute (\code{attr})
we wish to get from the nodes}

\item{include_leaves}{logical. Should leaves attributes be included as well?}

\item{include_branches}{logical. Should non-leaf (branch node)
attributes be included as well?}

\item{na.rm}{logical. Should NA attributes be REMOVED from the resulting vector?}

\item{...}{not used}
}
\value{
A vector with the dendrogram's nodes attribute. If an attribute is missing
from some nodes, it will return NA in that vector.
}
\description{
Allows easy access to attributes of branches and/or leaves, with option
of returning a vector with/withough NA's (for marking the missing attr value)
}
\examples{
# define dendrogram object to play with:
hc <- hclust(dist(USArrests[1:3,]), "ave")
dend <- as.dendrogram(hc)

# get_leaves_attr(dend) # error :)
get_leaves_attr(dend, "label")
labels(dend, "label")
get_leaves_attr(dend, "height") # should be 0's
get_nodes_attr(dend, "height")


get_leaves_attr(dend, "leaf") # should be TRUE's
get_nodes_attr(dend, "leaf") # conatins NA's


get_leaves_attr(dend, "members") # should be 1's
get_nodes_attr(dend, "members", include_branches = FALSE, na.rm = TRUE) #
get_nodes_attr(dend, "members") #
get_nodes_attr(dend, "members", include_leaves = FALSE, na.rm = TRUE) #


hang_dend <- hang.dendrogram(dend)
get_leaves_attr(hang_dend, "height") # no longer 0!
get_nodes_attr(hang_dend, "height") # does not include any 0s!

# does not include leaves values:
get_nodes_attr(hang_dend, "height", include_leaves = FALSE)
# remove leaves values all together:
get_nodes_attr(hang_dend, "height", include_leaves = FALSE, na.rm = TRUE)



\dontrun{
require(microbenchmark)
# get_leaves_attr is twice faster than get_nodes_attr
microbenchmark(   get_leaves_attr(dend, "members"), # should be 1's
                    get_nodes_attr(dend, "members", include_branches = FALSE, na.rm = TRUE)
               )
}
}
\seealso{
\link{get_leaves_attr}, \link{nnodes}, \link{nleaves}
}

