% Generated by roxygen2 (4.0.2): do not edit by hand
\name{dend_diff}
\alias{dend_diff}
\alias{dend_diff.dendlist}
\alias{dend_diff.dendrogram}
\title{Plots two trees side by side, highlighting edges unique to each tree in red.}
\source{
A \link{dendrogram} implementation for \link[distory]{phylo.diff} from the {distory} package
}
\usage{
dend_diff(x, ...)

\method{dend_diff}{dendrogram}(x, y, horiz = TRUE,
                  ...)

\method{dend_diff}{dendlist}(x, ..., which)
}
\arguments{
\item{x}{a dendrogram or \link{dendlist} to compre with}

\item{...}{passed to \link{plot.dendrogram}}

\item{y}{a dendrogram to compare with}

\item{horiz}{logical (TRUE) indicating if the dendrogram should be drawn horizontally or not.}

\item{which}{an integer vector indicating, in the case "x" is a dendlist,
on which of the trees should the modification be performed.
If missing - the change will be performed on all of objects in the dendlist.}
}
\value{
Invisible \link{dendlist} of both trees.
}
\description{
Plots two trees side by side, highlighting edges unique to each tree in red.
}
\examples{
x <- 1:5 \%>\% dist \%>\% hclust \%>\% as.dendrogram
y <- set(x, "labels", 5:1)

dend_diff(x, y)
dend_diff(dendlist(x, y))
dend_diff(dendlist(y, x))

dend1 <- 1:10 \%>\% dist \%>\% hclust \%>\% as.dendrogram
dend2 <- dend1 \%>\% set("labels", c(1,3,2,4, 5:10) )
dend_diff(dend1, dend2)
}
\seealso{
\link{distinct_edges}, \link{highlight_distinct_edges},
\link{dist.dendlist}, \link{tanglegram}
\link{assign_values_to_branches_edgePar},
\link[distory]{distinct.edges},
}

