% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/entanglement.R
\name{entanglement}
\alias{entanglement}
\alias{entanglement.default}
\alias{entanglement.dendlist}
\alias{entanglement.dendrogram}
\alias{entanglement.hclust}
\alias{entanglement.phylo}
\title{Measures entanglement between two trees}
\usage{
entanglement(dend1, ...)

\method{entanglement}{dendrogram}(dend1, dend2, L = 1.5, leaves_matching_method = c("labels", "order"),...)

\method{entanglement}{dendlist}(dend1, which = c(1L,2L), ...)

\method{entanglement}{hclust}(dend1, dend2, ...)

\method{entanglement}{phylo}(dend1, dend2, ...)
}
\arguments{
\item{dend1}{a tree object (of class dendrogram/hclust/phylo).}

\item{...}{not used}

\item{dend2}{a tree object (of class dendrogram/hclust/phylo).}

\item{which}{an integer vector of length 2, indicating
which of the trees in a dendlist object should have
their entanglement calculated}

\item{L}{the distance norm to use for measuring the distance between the
two trees. It can be any positive number, often one will want to
 use 0, 1, 1.5, 2 (see 'details' for more).}

\item{leaves_matching_method}{a character scalar, either "order"
or "labels" (default) . If using "labels", then we use the labels for
matching the leaves order value (safer).

And if "order" then we use the old leaves order value for matching the
leaves order value.

Using "order" is faster, but "labels" is safer. "order" will assume that
the original two trees had their labels and order values MATCHED.

Hence, it is best to make sure that the trees used here have the same labels
and the SAME values matched to these values - and then use "order" (for
fastest results).}
}
\value{
The number of leaves in the tree
}
\description{
Measures the entanglement between two trees.
Entanglement is a measure between 1 (full entanglement) and 0
(no entanglement). The exact behavior of the number depends on the L norm
which is chosen.
}
\details{
Entanglement is measured by giving the left tree's labels the values of
1 till tree size, and than match these numbers with the right tree.
Now, entanglement is the L norm distance between these two vectors.
That is, we take the sum of the absolute difference (each one in the power
of L). e.g: \code{sum(abs(x-y)**L)}.
And this is devided by the "worst case" entanglement level (e.g:
when the right tree is the complete reverse of the left tree).

L tells us which panelty level we are at (L0, L1, L2, partial L's etc).
L>1 means that we give a big panelty for sharp angles.
While L->0 means that any time something is not a streight horizontal line,
it gets a large penalty
If L=0.1 it means that we much prefer streight lines over non streight lines
}
\examples{
\dontrun{
dend1 <- iris[,-5] \%>\% dist \%>\% hclust("com") \%>\% as.dendrogram
dend2 <- iris[,-5] \%>\% dist \%>\% hclust("sin") \%>\% as.dendrogram
dend12 <- dendlist(dend1, dend2)
tanglegram(dend12)

entanglement(dend12)
entanglement(dend12, L = 0)
entanglement(dend12, L = 0.25)
entanglement(dend1,dend2, L = 0) # 1
entanglement(dend1,dend2, L = 0.25) # 0.97
entanglement(dend1,dend2, L = 1) # 0.93
entanglement(dend1,dend2, L = 2) # 0.88

# a somewhat better tanglegram
tanglegram(sort(dend1),sort(dend2))
# and alos a MUCH better entanglement
entanglement(sort(dend1),sort(dend2), L=1.5) # 0.0811
# but not that much, for L=0.25
entanglement(sort(dend1),sort(dend2), L=.25) # 0.579



##################
##################
##################
# massing up the order of leaves is dangerous:
entanglement(dend1 , dend2, 1.5, "order") # 0.91
order.dendrogram(dend2) <- seq_len(nleaves(dend2))
# this 0.95 number is NO LONGER correct!!
entanglement(dend1 , dend2, 1.5, "order") # 0.95
# but if we use the "labels" method - we still get the correct number:
entanglement(dend1 , dend2, 1.5, "labels") # 0.91

# however, we can fix our dend2, as follows:
dend2 <- match_order_by_labels(dend2, dend1)
# Now that labels and order are matched - entanglement is back at working fine:
entanglement(dend1 , dend2, 1.5, "order") # 0.91



}
}
\seealso{
\link{tanglegram}, \link{match_order_by_labels}.
}

