% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/d3dendrogram.R
\name{d3dendro_options}
\alias{d3dendro_options}
\title{Get or set current defaults for d3dendrogram}
\usage{
d3dendro_options(..., copy = FALSE)
}
\arguments{
\item{...}{\code{<option>=<value>} pairs (see below). If no option/value pair is given, a list with
current settings is returned. If the single input \code{"reset"} is given, options
are restored to factory settings.}

\item{copy}{only when options are set: set global options or return a modified copy of the global
   option environment invisibly?}
}
\description{
Get or set current defaults for d3dendrogram
}
\section{Options}{

Option values are exported as-is to the generated javascript/webpage.

\tabular{ll}{
  \code{node_fill (char,"#fff")}             \tab Node color (fill) \cr
  \code{node_stroke (char;"steelblue")}      \tab Node color (circumference)\cr
  \code{node_stroke_width (char;"1.5px")}    \tab Width of node circumference \cr
  \code{node_radius (num;4.5)}               \tab Size of node (pixels) \cr
  \code{node_font (char;"14px sans-serif")}  \tab Font used to print labels. Size and type spec\cr
  \code{link_fill (char;"none")}             \tab link fill color (you probably do not want to set this)\cr
  \code{link_stroke (char;"#ccc")}           \tab link line color (that's the one you want)\cr
  \code{link_stroke_width (char;"1.5px")}    \tab link line width (pixels) \cr
  \code{axis_stroke (char;"black")}          \tab Color of axis line\cr
  \code{axis_width (char; "2px")}            \tab Width of axis line\cr
  \code{axis_ntick (num; 5)}                 \tab Approximate nr of tick marks\cr
  \code{axis_ticklength_in (num;5)}          \tab Length of tickmarks into the graph (pixels)  \cr
  \code{axis_ticklength_out (num;5)}         \tab Length of tickmarks out of the graph (pixels)\cr
  \code{axis_tickmark_offset (num;8)}        \tab Distance between axis and tick labels (pixels)
}
}

