% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/attr_access.R
\name{get_leaves_branches_col}
\alias{get_leaves_branches_col}
\title{Get the colors of the branches of a dendrogram's leaves}
\usage{
get_leaves_branches_col(dend, ...)
}
\arguments{
\item{dend}{a dendrogram object}

\item{...}{not used}
}
\value{
A vector with the dendrogram's leaves' branches' colors
}
\description{
It is useful to get the colors of branches of the leaves,
after we use \link{color_branches}, so to then match the colors of the labels
to that of the branches (since getting the colors of branches to match
those of the labels can be tricky).
This is based on \link{get_leaves_branches_attr} which is based on
\link{get_leaves_edgePar}.
}
\examples{
# define dendrogram object to play with:
hc <- hclust(dist(USArrests[1:5,]), "ave")
dend <- as.dendrogram(hc)

par(mfrow = c(1,2), mar = c(5,2,1,0))
dend <- dend \%>\%
         color_branches(k = 3) \%>\%
         set("branches_lwd", c(2,1,2)) \%>\%
         set("branches_lty", c(1,2,1))

plot(dend)

labels_colors(dend)  <- get_leaves_branches_col(dend)
plot(dend)
}
\seealso{
\link{get_nodes_attr}, \link{assign_values_to_leaves_nodePar}, \link{labels_colors}
\link{get_leaves_nodePar}, \link{get_leaves_edgePar}, \link{get_leaves_branches_attr}
}

