% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hol_rom.R
\docType{data}
\name{hol_rom}
\alias{hol_rom}
\title{Roman tree-ring site chronologies from Hollstein}
\format{
An object of class \code{"rwl"}.
}
\usage{
data(hol_rom)
}
\description{
Dendrochronological site chronologies published by Hollstein (1972, 1980). These 52 (pre) Roman site chronologies date between 502 BC and AD 550. This selection of (pre)Roman site-chronologies are also used by Visser (2021) and made available as Visser (2022).
}
\examples{
data(hol_rom)
sim_table(hol_rom, last_digit_radius = TRUE)

}
\references{
Hollstein, E. 1972 Dendrochronologische Datierung von Hölzern aus Wederath (Belginum). Trierer Zeitschrift 35: 123–125.

Hollstein, E. 1980. Mitteleuropäische Eichenchronologie. Trierer Dendrochronologische Forschungen zur Archäologie und Kunstgeschichte. Trierer Grabungen und Forschungen 11. Mainz am Rhein: Verlag Philipp von Zabern.

Visser, RM. 2021 Dendrochronological Provenance Patterns. Network Analysis of Tree-Ring Material Reveals Spatial and Economic Relations of Roman Timber in the Continental North-Western Provinces. Journal of Computer Applications in Archaeology 4(1): 230–253. DOI: https://doi.org/10.5334/jcaa.79.

Visser, RM. 2022 Dendrochronological Provenance Patterns. Code and Data of Network Analysis of Tree-Ring Material. DOI: https://doi.org/10.5281/zenodo.7157744.
}
\keyword{datasets}
\keyword{dendrochronology}
