% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrometry.R
\name{reducecoef}
\alias{reducecoef}
\title{The reduction coefficient}
\usage{
reducecoef(middle, breast)
}
\arguments{
\item{middle}{numeric, the diameter or circumference at middle height.}

\item{breast}{numeric, the diameter or circumference at breast height.}
}
\value{
The reduction coefficient.
}
\description{
The reduction coefficient is the ratio between the difference
in size at breast height and mid-height on the one hand, and the size at
breast height on the other. . It is thus the complement to 1 of the
coefficient of decrease.
}
\details{
Both \code{middle} and \code{breast} arguments should be of the
same type (either diameter or circumference). Don't mix.
}
\examples{
reducecoef(30, 120)
reducecoef(middle = 40, breast = 90)
}
