% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrometry.R
\name{fiboRate}
\alias{fiboRate}
\title{Fibonacci series ratio}
\usage{
fiboRate(n, PrintSer = FALSE, Uo = 0, U1 = 1)
}
\arguments{
\item{n}{integer, the size of the series.}

\item{PrintSer}{logical, indicating if the series should be printed.}

\item{Uo, U1}{integer, the first number of the series.}
}
\value{
Either a numeric, result of the rate of \code{nth} and \code{(n-1)th} numbers
in Fibonacci series or all \code{(n-1)th} those rates.
}
\description{
Computes rates from Fibonacci series.
}
\details{
The series equation is Un = U_(n-2) /U_(n-1).
The function returns golden number when Uo = 0, and U1 = 1. Larger n is, more precise the number (result) is.
}
\examples{
##Golden number (Le Nombre d'Or)
fiboRate(n = 18, PrintSer = FALSE, Uo = 0, U1 = 1)
##(1+sqrt(5))/2
fiboRate(n = 10, PrintSer = TRUE, Uo = 0, U1 = 1)
}
\seealso{
\code{\link{fibonacci}}
}
\author{
Narcisse Yehouenou \email{narcisstar211@gmail.com}
}
