% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrometry.R
\name{param_i}
\alias{param_i}
\alias{param}
\title{Structural parameters for stands}
\usage{
param_i(data, plot = "", DBH = "", height = "", crown = "", area = NULL,
k = 100, kCrown = 1)

param(data, plot = "", DBH = "", height = "", crown = "", area = NULL,
k = 100, kCrown = 1, factor1 = "", factor2 = "", factor3 = "")
}
\arguments{
\item{data}{a data frame, list, tibble or object coercible by
\code{\link{as.data.frame}} to a data frame containing the variables whose
names would be given in \code{DBH}, \code{height} and \code{crown}.}

\item{plot, DBH, height, crown}{optional characters, names of the variables of
\code{data} containing respectively the plot's identification or code,
the diameter at breast height, the tree total height, and the crown diameter
of each individual tree.}

\item{area}{numeric, area of a plot (see \code{\link{basal}} section
\code{details} for unit).}

\item{k, kCrown}{numeric, used to convert diameter and crown diameter units
respectively. Default are \code{k = 100} and \code{kCrown = 1}.
(see \code{\link{basal}})}

\item{factor1, factor2, factor3}{character, optional variables of the data frame
that define subsets to consider.}
}
\value{
A vector, matrix or list of matrices containing of structural
parameters.
}
\description{
\code{param} computes structural parameters per stands specified in factor arguments.  \cr
\code{param_i} computes structural parameters for a stand.
}
\details{
Blackman and Green indices are returned if combinations of specified
\code{factor1..3}
contain more than one plot. Otherwise, the right are returned as attributes.
}
\examples{
param_i(
  data = Logging, plot = "tree", DBH = "diametreMedian",
  height = "hauteur", crown = "perimetreBase", area = 0.03, kCrown = 100
)
}
