% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_test_welch.r
\name{t_test_welch}
\alias{t_test_welch}
\title{Welch's t-Test}
\usage{
t_test_welch(data, alternative = "two.sided", ci_level = NULL, mean_null = 0)
}
\arguments{
\item{data}{(list)\cr
A list whose first element is the vector of normal values from group
1 and the second element is the vector of normal values from group 2.
\link[base]{NA}s are silently excluded. The default output from
\code{\link[=sim_log_lognormal]{sim_log_lognormal()}}.}

\item{alternative}{(string: \code{"two.sided"})\cr
The alternative hypothesis. Must be one of \code{"two.sided"}, \code{"greater"},
or \code{"less"}. See 'Details' for additional information.}

\item{ci_level}{(Scalar numeric: \code{NULL}; \verb{(0, 1)})\cr
If \code{NULL}, confidence intervals are set as \code{NA}. If in \verb{(0, 1)},
confidence intervals are calculated at the specified level.}

\item{mean_null}{(Scalar numeric: \code{0}; \verb{(-Inf, Inf)})\cr
The difference of means assumed under the null hypothesis. See
'Details' for additional information.}
}
\value{
A list with the following elements:
\tabular{llll}{
Slot \tab Subslot \tab Name \tab Description \cr
1 \tab   \tab \code{t}  \tab Value of the t-statistic. \cr
2 \tab   \tab \code{df} \tab Degrees of freedom for the t-statistic. \cr
3 \tab   \tab \code{p}  \tab p-value. \cr

4 \tab   \tab \code{diff_mean} \tab Estimated difference of means
(group 2 – group 1). \cr
4 \tab 1 \tab \code{estimate}  \tab Point estimate. \cr
4 \tab 2 \tab \code{lower}     \tab Confidence interval lower bound. \cr
4 \tab 3 \tab \code{upper}     \tab Confidence interval upper bound. \cr

5 \tab   \tab \code{mean1} \tab Estimated mean of group 1. \cr
6 \tab   \tab \code{mean2} \tab Estimated mean of group 2. \cr
7 \tab   \tab \code{n1} \tab Sample size of group 1. \cr
8 \tab   \tab \code{n2} \tab Sample size of group 2. \cr
9  \tab   \tab \code{method}      \tab Method used for the results. \cr
10 \tab   \tab \code{alternative} \tab The alternative hypothesis. \cr
11 \tab   \tab \code{ci_level}    \tab The confidence level. \cr
12 \tab   \tab \code{mean_null}   \tab Assumed population difference of the means
under the null hypothesis.
}
}
\description{
Performs Welch's independent two-sample t-test.
}
\details{
This function is primarily designed for speed in simulation. Missing values
are silently excluded.

The hypotheses for Welch's independent two-sample t-test are

\deqn{
\begin{aligned}
H_{null} &: \mu_2 - \mu_1 = \mu_{null} \\
H_{alt} &: \begin{cases}
  \mu_2 - \mu_1 \neq \mu_{null} & \text{two-sided}\\
  \mu_2 - \mu_1 > \mu_{null} & \text{greater than}\\
  \mu_2 - \mu_1 < \mu_{null} & \text{less than}
\end{cases}
\end{aligned}
}

where \eqn{\mu_1} is the population mean of group 1, \eqn{\mu_2} is the
population mean of group 2, and \eqn{\mu_{null}} is a constant for the assumed
difference of population means (usually \eqn{\mu_{null} = 0}).

The test statistic is

\deqn{
T = \frac{(\bar{x}_2 - \bar{x}_1) - \mu_{null}}{\sqrt{\frac{s_1^2}{n_1} + \frac{s_2^2}{n_2}}}
}

where \eqn{\bar{x}_1} and \eqn{\bar{x}_2} are the sample means, \eqn{\mu_{null}}
is the difference of population means assumed under the null hypothesis,
\eqn{n_1} and \eqn{n_2} are the sample sizes, and \eqn{s_1^2} and \eqn{s_2^2}
are the sample variances.

The critical value of the test statistic uses the Welch–Satterthwaite degrees
of freedom

\deqn{
v = \frac{\left( \frac{s_1^2}{n_1} + \frac{s_2^2}{n_2} \right)^2}
         {(N_1 - 1)^{-1}\left( \frac{s_1^2}{n_1} \right)^2 +
         (N_2 - 1)^{-1}\left( \frac{s_2^2}{n_2} \right)^2}
}

and the p-value is calculated as

\deqn{
\begin{aligned}
p &= \begin{cases}
  2 \text{min} \{P(T \geq t_{v} \mid H_{null}), P(T \leq t_{v} \mid H_{null})\} & \text{two-sided}\\
  P(T \geq t_{v} \mid H_{null}) & \text{greater than}\\
  P(T \leq t_{v} \mid H_{null}) & \text{less than}
\end{cases}
\end{aligned}
}

Let \eqn{GM(\cdot)} be the geometric mean and \eqn{AM(\cdot)} be the
arithmetic mean. For independent lognormal variables \eqn{X_1} and \eqn{X_2}
it follows that \eqn{\ln X_1} and \eqn{\ln X_2} are independent normally
distributed variables. Defining
\eqn{\mu_{X_2} - \mu_{X_1} = AM(\ln X_2) - AM(\ln X_1)}
we have

\deqn{
e^{\mu_{X_2} - \mu_{X_1}} = \frac{GM(X_2)}{GM(X_1)}
}

This forms the basis for making inference about the ratio of geometric means
of the original lognormal data using the difference of means of the log
transformed normal data.
}
\examples{
#----------------------------------------------------------------------------
# t_test_welch() examples
#----------------------------------------------------------------------------
library(depower)

# Welch's t-test
set.seed(1234)
sim_log_lognormal(
  n1 = 40,
  n2 = 40,
  ratio = 1.5,
  cv1 = 0.4,
  cv2 = 0.4
) |>
  t_test_welch(ci_level = 0.95)

}
\references{
\insertRef{julious_2004}{depower}

\insertRef{hauschke_1992}{depower}

\insertRef{johnson_1994}{depower}
}
\seealso{
\code{\link[stats:t.test]{stats::t.test()}}
}
