\docType{data}

\name{data.wage}

\alias{data.wage}

\title{Wage Data in a Company}

\format{
A data frame with 20 observations on the following six variables:
\tabular{ll}{
\code{wage} \tab employee's monthly wage (in euro).\cr
\code{educ} \tab employee's extra education beyond the basic schooling degree (in years).\cr
\code{age} \tab employee's age (in years).\cr
\code{empl} \tab employee's time of employment in the company (in years).\cr
\code{score} \tab employee's IQ test score.\cr
\code{sex} \tab employee's sex (0 = male).\cr
\code{religion} \tab employee's religion (factor variable).\cr
}
}

\source{
Auer, L.v. (2023): Ökonometrie - Eine Einführung, 8th ed., Springer-Gabler (\href{https://www.uni-trier.de/index.php?id=15929}{https://www.oekonometrie-lernen.de}).
}

\usage{
data.wage
}

\description{
This is a data set on the wage structure in a company.
}

\details{
In Auer (2023, Chap. 13) and Auer et al. (2023, Chap. 13) these hypothetical data are used to illustrate the selection of the relevant exogenous variables.
}

\references{
Auer, L.v., Hoffmann, S. & Kranz, T. (2023): Ökonometrie - Das R-Arbeitsbuch, 2nd ed., Springer-Gabler (\bold{https://www.oekonometrie-lernen.de}).
}

\keyword{datasets}
