% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectGlasso.R
\name{detectGlasso}
\alias{detectGlasso}
\title{Change point detection using Graphical lasso as in Cribben et al. (2012)}
\usage{
detectGlasso(
  Y,
  Del,
  p,
  lambda = "bic",
  nboot = 100,
  n.cl,
  bound = c(0.001, 1),
  gridTF = FALSE,
  plotTF = TRUE
)
}
\arguments{
\item{Y}{Input data of dimension length*dim (T times d)}

\item{Del}{Delta away from the boundary restriction}

\item{p}{Gep(p) distribution controls the size of stationary bootstrap. The mean block length is 1/p}

\item{lambda}{two selections possible for optimal parameter of lambda. "bic" finds lambda from bic criteria, or user can directly input the penalty value}

\item{nboot}{the number of bootstrap sample for pvalue. Default is 100.}

\item{n.cl}{number of cores in parallel computing. The default is (machine cores - 1)}

\item{bound}{bound of bic search in "bic" rule. Default is (.001, 1)}

\item{gridTF}{minimum bic is found by grid search. Default is FALSE}

\item{plotTF}{Draw plot to see test statistic}
}
\value{
A list with component

\strong{br} The estimated breakpoints including boundary (0, T)

\strong{brhist} The sequence of breakspoints found from binay splitting

\strong{diffhist} The history of BIC reduction on each step

\strong{W} The estimated vecorized autocovariance on each regime.

\strong{WI} The estimated vecorized precision matrix on each regime.

\strong{lambda} The penalty parameter estimated on each regime.

\strong{pvalhist} The empirical p-values on each binary spltting.

\strong{fitzero} Detailed output at first stage. Useful in producing plot.
}
\description{
This function implements the Dynamic Connectivity Regression (DCR) algorithm proposed by Cribben el al. (2012) to locate changepoints.
}
\examples{
\donttest{out1= detectGlasso(changesim, p=.2, n.cl=1)}
}
