#' Beta equation of developmental rate as a function of temperature.
#'
#' Yin, X., Kropff, M.J., McLaren, G., and Visperas, R.M. (1995) A nonlinear model for crop
#' development as a function of temperature. Agricultural and Forest Meteorology 77(1): 1-16.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1016/0168-1923(95)02236-Q}
"beta_95"

#' Performance-2 equation of developmental rate as a function of temperature.
#'
#' Shi, P., Ge, F., Sun, Y., and Chen, C. (2011) A simple model for describing the effect of
#' temperature on insect developmental rate. Journal of Asia-Pacific Entomology 14(1): 15-20.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1016/j.aspen.2010.11.008}
"perf2_11"

#' Root square equation of developmental rate as a function of temperature.
#'
#' Ratkowsky, D.A., Olley, J., McMeekin, T.A., and Ball, A. (1982) Relationship between
#' temperature and growth rate of bacterial cultures. Journal of Bacteriology 149(1): 1-5.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://jb.asm.org/content/149/1/1}
"rootsq_82"

#' Wang and Engel equation of developmental rate as a function of temperature.
#'
#' Wang, E., and Engel, T. (1998) Simulation of phenological development of wheat crops.
#' Agricultural systems 58(1): 1-24.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1016/S0308-521X(98)00028-6}
"wangengel_98"

#' Ratkowsky equation of developmental rate as a function of temperature.
#'
#' Ratkowsky, D.A., Olley, J., McMeekin, T.A., and Ball, A. (1982) Relationship between
#' temperature and growth rate of bacterial cultures. Journal of Bacteriology 149(1): 1-5.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://jb.asm.org/content/149/1/1}
"ratkowsky_82"

#' Regniere equation of developmental rate as a function of temperature.
#'
#' Regniere, J., Powell, J., Bentz, B., and Nealis, V. (2012) Effects of temperature on
#' development, survival and reproduction of insects: experimental design, data analysis
#' and modeling. Journal of Insect Physiology 58(5): 634-47.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1016/j.jinsphys.2012.01.010}
"regniere_12"

#' Shi equation of developmental rate as a function of temperature.
#'
#' Shi, P., Ge, F., Sun, Y., and Chen, C. (2011) A simple model for describing the effect of
#' temperature on insect developmental rate. Journal of Asia-Pacific Entomology 14(1): 15-20.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1016/j.aspen.2010.11.008}
"shi_11"

#' Hansen equation of developmental rate as a function of temperature.
#'
#' Hansen, E.M., Bentz, B.J., Powell, J.A., Gray, D.R., and Vandygriff, J.C. (2011) Prepupal
#' diapause and instar IV developmental rates of the spruce beetle, Dendroctonus rufipennis
#' (Coleoptera: Curculionidae, Scolytinae). Journal of insect physiology 57(10): 1347-57.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1016/j.jinsphys.2011.06.011}
"hansen_11"

#' Janisch equation of developmental rate as a function of temperature.
#'
#' Janisch, E. (1932) The influence of temperature on the life-history of insects.
#' Transactions of the Royal Entomological Society of London 80(2): 137-68.
#' Analytis, S. (1977) Uber die Relation zwischen biologischer Entwicklung und
#' Temperatur bei phytopathogenen Pilzen. Journal of Phytopathology 90(1): 64-76.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1111/j.1365-2311.1932.tb03305.x}
"janisch_32"

#' Davidson equation of developmental rate as a function of temperature.
#'
#' Davidson, J. (1944). On the relationship between temperature and rate of development of insects
#' at constant temperatures. The Journal of Animal Ecology:26-38.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.2307/1326}
"davidson_44"

#' Campbell et al. equation of developmental rate as a function of temperature.
#'
#' Campbell, A., Frazer, B. D., Gilbert, N. G. A. P., Gutierrez, A. P., & Mackauer, M. (1974).
#' Temperature requirements of some aphids and their parasites. Journal of applied ecology, 431-438.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.2307/2402197}
"campbell_74"

#' Stinner et al equation of developmental rate as a function of temperature.
#'
#' Stinner, R., Gutierrez, A. & Butler, G. (1974) An algorithm for temperature-dependent growth
#' rate simulation. The Canadian Entomologist, 106, 519-524.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.4039/Ent106519-5}
"stinner_74"

#' Logan et al. equation 6 of developmental rate as a function of temperature.
#'
#' Logan, J. A., Wollkind, D. J., Hoyt, S. C., and Tanigoshi, L. K. (1976). An analytic model
#' for description of temperature dependent rate phenomena in arthropods. Environmental
#' Entomology, 5(6), 1133-1140.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1093/ee/5.6.1133}
"logan6_76"

#' Logan et al. equation 10 of developmental rate as a function of temperature.
#'
#' Logan, J. A., Wollkind, D. J., Hoyt, S. C., and Tanigoshi, L. K. (1976). An analytic model
#' for description of temperature dependent rate phenomena in arthropods. Environmental
#' Entomology, 5(6), 1133-1140.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1093/ee/5.6.1133}
"logan10_76"

#' Sharpe and DeMichele equation of developmental rate as a function of temperature.
#'
#' Sharpe, P.J. & DeMichele, D.W. (1977) Reaction kinetics of poikilotherm development.
#' Journal of Theoretical Biology, 64, 649-670.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1016/0022-5193(77)90265-X}
"sharpeDeMichele_77"

#' Analytis equation of developmental rate as a function of temperature.
#'
#' Analytis, S. (1977) Uber die Relation zwischen biologischer Entwicklung und Temperatur bei
#' phytopathogenen Pilzen. Journal of Phytopathology 90(1): 64-76.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1111/j.1439-0434.1977.tb02886.x}
"analytis_77"

#' Schoolfield et al. equation of developmental rate as a function of temperature.
#'
#' Schoolfield, R., Sharpe, P. & Magnuson, C. (1981) Non-linear regression of biological
#' temperature-dependent rate models based on absolute reaction-rate theory.
#' Journal of theoretical biology, 88, 719-731.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1016/0022-5193(81)90246-0}
"schoolfield_81"

#' Taylor equation of developmental rate as a function of temperature.
#'
#' Taylor, F. (1981) Ecology and evolution of physiological time in insects.
#' American Naturalist, 1-23.
#' Lamb, RJ. (1992) Developmental rate of Acyrthosiphon pisum (Homoptera: Aphididae) at low
#' temperatures: implications for estimating rate parameters for insects.
#' Environmental Entomology 21(1): 10-19.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://www.jstor.org/stable/2460694}
"taylor_81"

#'  Second-order polynomial equation of developmental rate as a function of temperature.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
"poly2"

#' Harcourt and Yee equation of developmental rate as a function of temperature.
#'
#' Harcourt, D. and Yee, J. (1982) Polynomial algorithm for predicting the duration of insect
#' life stages. Environmental Entomology, 11, 581-584.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1093/ee/11.3.581}
"harcourtYee_82"

#' Fourth-order polynomial equation of developmental rate as a function of temperature.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
"poly4"

#' Holling type III equation of developmental rate as a function of temperature.
#'
#' Hilbert, DW, y JA Logan (1983) Empirical model of nymphal development for the migratory
#' grasshopper, Melanoplus sanguinipes (Orthoptera: Acrididae).
#' Environmental Entomology 12(1): 1-5.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1093/ee/12.1.1}
"hilbertLogan_83"

#' Lamb equation of developmental rate as a function of temperature.
#'
#' Lamb, R. J., Gerber, G. H., & Atkinson, G. F. (1984). Comparison of developmental rate curves
#' applied to egg hatching data of Entomoscelis americana Brown (Coleoptera: Chrysomelidae).
#' Environmental entomology, 13(3), 868-872.
#' Lamb, RJ. (1992) Developmental rate of Acyrthosiphon pisum (Homoptera: Aphididae) at low
#' temperatures: implications for estimating rate parameters for insects.
#' Environmental Entomology 21(1): 10-19.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1093/ee/21.1.10}
"lamb_92"

#' Lactin et al. equation 1 of developmental rate as a function of temperature.
#'
#' Lactin, Derek J, NJ Holliday, DL Johnson, y R Craigen (995) Improved rate model of
#' temperature-dependent development by arthropods. Environmental Entomology 24(1): 68-75.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1093/ee/24.1.68}
"lactin1_95"

#' Lactin et al. equation 2 of developmental rate as a function of temperature.
#'
#' Lactin, Derek J, NJ Holliday, DL Johnson, y R Craigen (995) Improved rate model of
#' temperature-dependent development by arthropods. Environmental Entomology 24(1): 68-75.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1093/ee/24.1.68}
"lactin2_95"

#' Briere et al equation 1 of developmental rate as a function of temperature.
#'
#' Briere, J.F., Pracros, P., le Roux, A.Y. and Pierre, S. (1999) A novel rate model of
#' temperature-dependent development for arthropods. Environmental Entomology, 28, 22-29.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1093/ee/28.1.22 }
"briere1_99"

#' Briere et al equation 2 of developmental rate as a function of temperature.
#'
#' Briere, J.F., Pracros, P., le Roux, A.Y. and Pierre, S. (1999) A novel rate model of
#' temperature-dependent development for arthropods. Environmental Entomology, 28, 22-29.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1093/ee/28.1.22 }
"briere2_99"

#' Kontodimas et al. equation of developmental rate as a function of temperature.
#'
#' Kontodimas, D.C., Eliopoulos, P.A., Stathas, G.J. and Economou, L.P. (2004) Comparative
#' temperature-dependent development of Nephus includens (Kirsch) and Nephus bisignatus
#' (Boheman)(Coleoptera: Coccinellidae) preying on Planococcus citri
#' (Risso)(Homoptera: Pseudococcidae): evaluation of a linear and various nonlinear models
#' using specific criteria. Environmental Entomology 33(1): 1-11.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://ee.oxfordjournals.org/content/33/1/1}
"kontodimas_04"

#' Simplified beta type equation of developmental rate as a function of temperature.
#'
#' Damos, P.T., and Savopoulou-Soultani, M. (2008). Temperature-dependent bionomics and modeling
#' of Anarsia lineatella (Lepidoptera: Gelechiidae) in the laboratory.
#' Journal of economic entomology, 101(5), 1557-1567.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1093/jee/101.5.1557}
"damos_08"

#' Inverse second-order polynomial equation of developmental rate as a function of temperature.
#'
#' Damos, P., and Savopoulou-Soultani, M. (2011) Temperature-driven models for insect
#' development and vital thermal requirements. Psyche: A Journal of Entomology, 2012.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1155/2012/123405}
"damos_11"

#' Wang et al. equation of developmental rate as a function of temperature.
#'
#' Wang, R., Lan, Z. and Ding, Y. (1982) Studies on mathematical models of the relationship
#' between insect development and temperature. Acta Ecol. Sin, 2, 47-57.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://en.cnki.com.cn}
"wang_82"

#' Hansen equation of developmental rate as a function of temperature.
#'
#' Hansen, E.M., Bentz, B.J., Powell, J.A., Gray, D.R., and Vandygriff, J.C. (2011) Prepupal
#' diapause and instar IV developmental rates of the spruce beetle, Dendroctonus rufipennis
#' (Coleoptera: Curculionidae, Scolytinae). Journal of insect physiology 57(10): 1347-57.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1016/j.jinsphys.2011.06.011}
"hansen_11"

#' Shi equation of developmental rate as a function of temperature.
#'
#' Shi, P., Ge, F., Sun, Y., and Chen, C. (2011) A simple model for describing the effect of
#' temperature on insect developmental rate. Journal of Asia-Pacific Entomology 14(1): 15-20.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1016/j.aspen.2010.11.008}
"shi_11"

#' Regniere equation of developmental rate as a function of temperature.
#'
#' Regniere, J., Powell, J., Bentz, B., and Nealis, V. (2012) Effects of temperature on
#' development, survival and reproduction of insects: experimental design, data analysis and
#' modeling. Journal of Insect Physiology 58(5): 634-47.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1016/j.jinsphys.2012.01.010}
"regniere_12"

#' Ratkowsky equation of developmental rate as a function of temperature.
#'
#' Ratkowsky, D.A., Olley, J., McMeekin, T.A., and Ball, A. (1982) Relationship between
#' temperature and growth rate of bacterial cultures. Journal of Bacteriology 149(1): 1-5.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://jb.asm.org/}
"ratkowsky_82"

#' Wang Engel equation of developmental rate as a function of temperature.
#'
#' Wang, E., and Engel, T. (1998) Simulation of phenological development of wheat crops.
#' Agricultural systems 58(1): 1-24.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1016/S0308-521X(98)00028-6}
"wangengel_98"

#' Root square equation of developmental rate as a function of temperature.
#'
#' Ratkowsky, D.A., Olley, J., McMeekin, T.A., and Ball, A. (1982) Relationship between
#' temperature and growth rate of bacterial cultures. Journal of Bacteriology 149(1): 1-5.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://jb.asm.org/}
"rootsq_82"

#' Performance-2 equation of developmental rate as a function of temperature.
#'
#' Shi, P., Ge, F., Sun, Y., and Chen, C. (2011) A simple model for describing the effect of
#' temperature on insect developmental rate. Journal of Asia-Pacific Entomology 14(1): 15-20.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1016/j.aspen.2010.11.008}
"perf2_11"

#' Beta equation of developmental rate as a function of temperature.
#'
#' Yin, X., Kropff, M.J., McLaren, G., and Visperas, R.M. (1995) A nonlinear model for crop
#' development as a function of temperature. Agricultural and Forest Meteorology 77(1): 1-16.
#'
#' @format A list of eight elements describing the equation.
#' \describe{
#'   \item{eq}{The equation as a formula object.}
#'   \item{eqAlt}{The equation as a string.}
#'   \item{name}{The equation name.}
#'   \item{ref}{The equation reference.}
#'   \item{refShort}{The equation reference shortened.}
#'   \item{startVal}{The parameter values found in the literature with their references.}
#'   \item{com}{An otional comment about the equation use.}
#'   \item{id}{An id to identificate the equation.}
#' }
#' @source \url{http://dx.doi.org/10.1016/0168-1923(95)02236-Q}
"beta_95"

#' The list of all available equations of developmental rate as a function of temperature.
"devRateEqList"
