% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devRate_utils.R
\name{compDifDaysDf}
\alias{compDifDaysDf}
\title{Compute the inverse of number of days between dates from a data frame.}
\usage{
compDifDaysDf(dfDates, dateFormatDf = "\%d/\%m/\%y")
}
\arguments{
\item{dfDates}{A data.frame with dates (samples in columns and dates in rows).}

\item{dateFormatDf}{The format of dates (see \code{\link[base]{strptime}}).}
}
\value{
A data.frame with the inverse of the difference between dates.
}
\description{
Compute the inverse of number of days between dates from a data frame.
}
\examples{
myDays <- data.frame(egg =  c("28/12/15", "28/12/15", "28/12/15", "28/12/15"),
                         larva1 = c("12/01/16", "12/01/16", "12/01/16", "13/01/16"),
                         larva2 = c("25/01/16", "26/01/16", "25/01/16", "29/01/16"),
                         pupa = c("12/02/16", "10/02/16", "14/02/16", "09/02/16"),
                         imago = c("28/02/16", "25/02/16", "27/02/16", "26/02/16"),
                         death = c("15/03/16", "12/03/16", "19/03/16", "20/03/16"))
compDifDaysDf(dfDates = myDays, dateFormat = "\%d/\%m/\%y")
}
