% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devRate_pheno.R
\name{devRateIBMgen}
\alias{devRateIBMgen}
\title{Number of generations}
\usage{
devRateIBMgen(ibm)
}
\arguments{
\item{ibm}{The phenology model returned by devRateIBM function.}
}
\value{
The simulated number of generations.
}
\description{
Computes the number of generations from the individual-based model fit.
}
\examples{
rawDevEggs <- matrix(c(10, 0.031, 10, 0.039, 15, 0.047, 15, 0.059, 15.5, 0.066,
   13, 0.072, 16, 0.083, 16, 0.100, 17, 0.100, 20, 0.100, 20, 0.143, 25, 0.171,
   25, 0.200, 30, 0.200, 30, 0.180, 35, 0.001), ncol = 2, byrow = TRUE)
rawDevLarva <- matrix(c(10, 0.010, 10, 0.014, 10, 0.019, 13, 0.034, 15, 0.024,
   15.5, 0.029, 15.5, 0.034, 15.5, 0.039, 17, 0.067, 20, 0.050, 25, 0.076,
   25, 0.056, 30, 0.0003, 35, 0.0002), ncol = 2, byrow = TRUE)
rawDevPupa <- matrix(c(10, 0.001, 10, 0.008, 10, 0.012, 13, 0.044, 15, 0.017,
   15, 0.044, 15.5, 0.039, 16, 0.034, 15.5, 0.037, 16, 0.051, 17, 0.051,
   20, 0.080, 20, 0.092, 25, 0.102, 25, 0.073, 30, 0.005,
   35, 0.0002), ncol = 2, byrow = TRUE)
mEggs <- devRateModel(eq = taylor_81, temp = rawDevEggs[,1], devRate = rawDevEggs[,2],
   startValues = list(Rm = 0.05, Tm = 30, To = 5))
mLarva <- devRateModel(eq = taylor_81, temp = rawDevLarva[,1], devRate = rawDevLarva[,2],
   startValues = list(Rm = 0.05, Tm = 25, To = 5))
mPupa <- devRateModel(eq = taylor_81, temp = rawDevPupa[,1], devRate = rawDevPupa[,2],
   startValues = list(Rm = 0.05, Tm = 30, To = 5))
forecastTsolanivora <- devRateIBM(
   tempTS = rnorm(n = 100, mean = 15, sd = 1),
   timeStepTS = 1,
   models = list(mEggs, mLarva, mPupa),
   numInd = 500,
   stocha = 0.015,
   timeLayEggs = 1)
devRateIBMgen(ibm = forecastTsolanivora)
}
