% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devRate_plot.R
\name{devRatePlot}
\alias{devRatePlot}
\title{Plot the empirical points and the regression}
\usage{
devRatePlot(eq, nlsDR, temp, devRate, rangeT = 10, optText = TRUE,
  spe = TRUE, ...)
}
\arguments{
\item{eq}{The name of the equation.}

\item{nlsDR}{The result returned by the \code{devRateModel} function.}

\item{temp}{The temperature.}

\item{devRate}{The developmental rate \code{(days)^-1}}

\item{rangeT}{The range of temperatures over which the regression is plotted.
This argument may be overwritten depending on the equation.}

\item{optText}{A logical indcating wether the name of the eqaution should be written
in the topright corner of the plot.}

\item{spe}{A logical indicating if special plotting rules from literature should apply.}

\item{...}{Aditional arguments for the plot.}
}
\value{
Nothing.
}
\description{
Plot the empirical points and the regression
}
\examples{
myT <- 5:15
myDev <- -0.05 + rnorm(n = length(myT), mean = myT, sd = 1) * 0.01
myNLS <- devRateModel(eq = campbell_74, temp = myT, devRate = myDev,
  startValues = list(aa = 0, bb = 0))
devRatePlot(eq = campbell_74, nlsDR = myNLS, temp = myT, devRate = myDev,
  spe = TRUE, pch = 16, lwd = 2, ylim = c(0, 0.10))
}
