% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_pkg_report.R
\name{create_pkg_report}
\alias{create_pkg_report}
\title{Generate a package report in HTML}
\usage{
create_pkg_report(
  pkgname,
  from = NULL,
  to = NULL,
  path = paste0(pkgname, " - summary report", from, "_", to),
  gh = NULL
)
}
\arguments{
\item{pkgname}{String containing the name of the package.}

\item{from}{String in the format of \code{YYYY-MM-DD} specifying the start date of
the reporting period. If set to \code{NULL}, the first day of the month of the
system date will be used.}

\item{to}{String in the format of \code{YYYY-MM-DD} specifying the end date of the
reporting period. If set to \code{NULL}, the last day of the month of the system
date will be used.}

\item{path}{Pass the file path and the desired file name, \emph{excluding the file
extension}. For example, \code{"my package report"}.}

\item{gh}{String in the format of \code{owner/repo} to specify the GitHub
repository that holds the package. Defaults to \code{NULL} by default, where
GitHub statistics will be omitted.}
}
\value{
Opens and saves a static HTML file in the active working directory
with the file name specified in \code{path}.
}
\description{
Create a package summary report in HTML
}
\details{
The package summary report contains the following pages:
\itemize{
\item usage and development KPIs and package description
\item CRAN download stats
\item Summary of functions
\item Summary of package dependencies
\item Summary of pull requests
\item Summary of issues
}
}
