% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dexter.R
\name{get_design}
\alias{get_design}
\title{Test design}
\usage{
get_design(db, format = c("long", "wide"), rows = c("booklet_id",
  "item_id", "item_position"), columns = c("item_id", "booklet_id",
  "item_position"), fill = NA)
}
\arguments{
\item{db}{A handle to the database, i.e. the output of \code{start_new_project}
or \code{open_project}}

\item{format}{return format, see below}

\item{rows}{variable that defines the rows, ignored if format='long'}

\item{columns}{variable that defines the columns, ignored if format='long'}

\item{fill}{If set, missing values will be replaced with this value, ignored if format='long'}
}
\value{
A data.frame with the design. The contents depend on the rows, columns and format parameters
 if \code{format} is \code{'long'} a data.frame with columns: booklet_id, item_id, item_position
 if \code{format} is \code{'wide'} a data.frame with the rows defined by the \code{rows} parameter and 
 the columns by the \code{columns} parameter, with the remaining variable (i.e. item_id, booklet_id or item_position)
 making up the cells
}
\description{
Retrieve all items that have been entered in the db
so far by booklet and position in the booklet
}
