% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enorm.R
\name{latent_cor}
\alias{latent_cor}
\title{Latent correlations}
\usage{
latent_cor(
  dataSrc,
  item_property,
  predicate = NULL,
  nDraws = 500,
  use = "complete.obs"
)
}
\arguments{
\item{dataSrc}{a connection to a dexter database or a data.frame with columns: person_id, item_id, item_score}

\item{item_property}{An item property to distinguish the different scales.}

\item{predicate}{An optional expression to subset data, if NULL all data is used}

\item{nDraws}{Number of draws for plausible values}

\item{use}{only complete.obs at this time. Respondents who don't have a score for one or more scales are removed.}
}
\value{
List containing a correlation matrix and corresponding standard deviations
}
\description{
Estimates correlations between latent traits. Use an item_property to distinguish the different scales. 
This function uses plausible values so results may differ slightly between calls. 
Note: this is a new and slightly experimental function and therefore still a bit slow. It will probably 
become faster in future versions of dexter.
}
