% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmm_ci_vis.R
\name{plot_generate_timeDependence}
\alias{plot_generate_timeDependence}
\title{95\% Coverage time dependence plots for dFCM}
\usage{
plot_generate_timeDependence(dataList.CI, scan.length, rois,
  save_fig = FALSE, output_dir = NULL, cores = 0)
}
\arguments{
\item{dataList.CI}{The path of confidence interval data}

\item{scan.length}{integer, usually set as number of total timepoints per scan}

\item{rois}{Numerical array, regions of interests to generate plots}

\item{save_fig}{logical, whether or not the plots should be saved as files}

\item{output_dir}{character, output directory of PNG-format figures}

\item{cores}{integer, indicate the number of cores to use in parallel execution}
}
\description{
Visualize the dFC time dependence  modeled in dynamic functional connectivity modelling along with its confidence band.
}
\examples{
data(DynModel_results) # Load sample model result object
scan.length <- DynModel_results$params$ntp_per_scan
plot_generate_timeDependence(DynModel_results$est_CI[1], scan.length, rois=c(114,134))
\dontshow{
rm(list = c('scan.length', 'DynModel_results'))
gc()
}
}
