% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.sgl}
\alias{plot.sgl}
\title{Plot models of the following object types: \code{"sgl"}, \code{"sgl_cv"}.}
\usage{
\method{plot}{sgl}(x, how_many = 10, ...)
}
\arguments{
\item{x}{Object of one of the following classes: \code{"sgl"}, \code{"sgl_cv"}..}

\item{how_many}{Defines how many predictors to plot. Plots the predictors in decreasing order of largest absolute value.}

\item{...}{further arguments passed to base function.}
}
\value{
A list containing:
\item{response}{The predicted response. In the logistic case, this represents the predicted class probabilities.}
\item{class}{The predicted class assignments. Only returned if type = "logistic" in the model object.}
}
\description{
Plots the pathwise solution of a cross-validation fit, from a call to one of the following: \code{\link[=dfr_sgl]{dfr_sgl()}}, \code{\link[=dfr_sgl.cv]{dfr_sgl.cv()}}, \code{\link[=dfr_adap_sgl]{dfr_adap_sgl()}}, \code{\link[=dfr_adap_sgl.cv]{dfr_adap_sgl.cv()}}.
}
\examples{
# specify a grouping structure
groups = c(1,1,2,2,3)
# generate data
data = sgs::gen_toy_data(p=5, n=4, groups = groups, seed_id=3,signal_mean=20,group_sparsity=1)
# run DFR-SGL
model = dfr_sgl(X = data$X, y = data$y, groups=groups, type = "linear", 
path_length = 20, alpha = 0.95, 
min_frac = 0.05, standardise="l2",intercept=TRUE,verbose=FALSE)
plot(model, how_many = 10)
}
\seealso{
\code{\link[=dfr_sgl]{dfr_sgl()}}, \code{\link[=dfr_sgl.cv]{dfr_sgl.cv()}}, \code{\link[=dfr_adap_sgl]{dfr_adap_sgl()}}, \code{\link[=dfr_adap_sgl.cv]{dfr_adap_sgl.cv()}}

Other SGL-methods: 
\code{\link{dfr_adap_sgl}()},
\code{\link{dfr_adap_sgl.cv}()},
\code{\link{dfr_sgl}()},
\code{\link{dfr_sgl.cv}()},
\code{\link{predict.sgl}()},
\code{\link{print.sgl}()}
}
\concept{SGL-methods}
