% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagmeta.R
\name{diagmeta}
\alias{diagmeta}
\title{Meta-analysis of diagnostic test accuracy studies with the multiple
cutoffs model}
\usage{
diagmeta(
  TP,
  FP,
  TN,
  FN,
  cutoff,
  studlab,
  data = NULL,
  distr = "logistic",
  model = "CICS",
  equalvar = FALSE,
  lambda = 0.5,
  log.cutoff = FALSE,
  method.weights = "invvar",
  level = 0.95,
  incr = 0.5,
  n.iter.max = 1000,
  tol = 1e-08,
  silent = TRUE,
  ...
)
}
\arguments{
\item{TP, FP, TN, FN}{Numeric vectors giving the number of true
positives, false positives, true negatives and false negatives}

\item{cutoff}{A number vector indicating the cutoff values}

\item{studlab}{A numeric or a character vector with study labels}

\item{data}{An optional data frame containing the study information}

\item{distr}{A character indicating the distribution (see Details)}

\item{model}{A character indicating the model (see Details)}

\item{equalvar}{A logical indicating whether the variances of the
biomarker in both groups are thought equal (see Details)}

\item{lambda}{A numeric between 0 and 1 indicating the weight of
the sensitivity (such that specificity receives weight 1 -
lambda)}

\item{log.cutoff}{A logical indicating whether the cutoffs should
be log-transformed}

\item{method.weights}{A character indicating the method for
weighting the studies: \code{invvar} (default) means inverse
variance weighting, \code{size} means weighting by group sample
size, \code{equal} means that all studies are equally weighted}

\item{level}{A numeric indicating the significance level (1 -
alpha) for tests (default is 0.95)}

\item{incr}{A numeric between 0 and 1 that is added as a continuity
correction}

\item{n.iter.max}{A numeric indicating the maximal number of fixed
point iterations for finding the optimal cutoff}

\item{tol}{A numeric indicating the tolerance for convergence of
the fixed point iteration}

\item{silent}{A logical indicating whether iterations should be
suppressed}

\item{\dots}{additional arguments}
}
\value{
An object of class "diagmeta" with corresponding print, summary,
and plot function. The object is a list containing the following
components
\item{TP, FP, TN, FN}{As defined above.}
\item{cutoff, studlab}{As defined above.}
\item{Sens}{Sensitivity (original data).}
\item{Spec}{Specificity (original data).}
\item{distr, model, equalvar, lambda}{As defined above.}
\item{log.cutoff, method.weights}{As defined above.}
\item{level, incr}{As defined above.}
\item{k}{The number of studies in the meta-analysis.}
\item{optcut}{The optimal cutoff.}
\item{lower.optcut, upper.optcut}{Corresponding lower and upper
  confidence limits (for normal distribution).}
\item{Sens.optcut}{The sensitivity at the optimal cutoff.}
\item{lower.Sens.optcut, upper.Sens.optcut}{Corresponding lower and
  upper confidence limits.}
\item{Spec.optcut}{The specificity at the optimal cutoff.}
\item{lower.Spec.optcut, upper.Spec.optcut}{Corresponding lower and
  upper confidence limits.}
\item{AUC}{Area under the curve (AUC)}
\item{AUCSens.lower, AUCSens.upper}{Corresponding lower and upper
  confidence limits (based on the confidence region for the
  sensitivity, given the specificity)}
\item{AUCSpec.lower, AUCSpec.upper}{Corresponding lower and upper
  confidence limits (based on the confidence region for the
  specificity, given the sensitivity)}
\item{var.diseased, var.nondiseased}{The within-study variance for
  the diseased and non-diseased group, respectively.}
\item{AIC}{The value of the Akaike information criterion of the
  lmer object.}
\item{BIC}{The value of the Bayesian information criterion of the
  lmer object.}
\item{data.lmer}{A list with elements Study (study labels), Group
  (group labels (0 or 1)), Cutoff, N (group sizes), Negative
  (number of negative test results), NN (frequencies of negative
  test results).}
\item{result.lmer}{An object of class \code{\link[lme4]{lmer}}.}
\item{weights}{Normalized weights per study, group, and cutoff such
  that the sum of weights is twice the number of cutoffs over all
  studies.}
\item{regr}{A list with point estimates, variances, and covariances
  from regression parameters of \code{\link[lme4]{lmer}} object.}
\item{dist}{A list containing estimated means, standard deviations,
  and variances of distributions from diseased (ending with 1) and
  non-diseased (ending with 0).}
\item{Cov.fixed}{Covariance matrix from fixed effects model.}
\item{call}{Function call.}
\item{version}{Version of R package \bold{diagmeta} used to create
  object.}
}
\description{
Diagnostic tests may be based on an ordinal or continuous biomarker
or an ordinal score together with a cutoff. The decision whether
the target condition is present or not (positive or negative test
result) depends on whether the observed value is above or below the
cutoff. Here we assume that higher values of the biomarker indicate
a greater probability for the target condition (e.g., a disease);
otherwise, the poling must be changed by multiplying all values of
the biomarker by -1. Sensitivity and specificity of the test depend
on the chosen cutoff and vary with the cutoff. In meta-analysis of
diagnostic accuracy studies, results are often reported for
multiple cutoffs within a study, and the cutoffs may differ between
studies.  The multiple cutoffs model creates a link between the
range of cutoffs and the respective pairs of sensitivity and
specificity and thus allows identifying cutoffs at which the test
is likely to perform best (Steinhauser et al., 2016).
}
\details{
Each row of the data set provides at least a study label, a cutoff
and the numbers of true positives, false positives, true negatives
and false negatives. Different studies may contribute a varying
number of cutoffs, as well as different sets of cutoffs.

The multiple cutoffs model is a multi-level random effects
model. At the study level, for the group of patients without the
target condition (in short disease-free), the specificities at all
available cutoffs together provide an estimate of the cumulative
distribution function (cdf) of the test results within the
disease-free individuals. Likewise, for patients with the target
condition (in short diseased), via the observed sensitivities at
all observed cutoffs we obtain an estimate of the cdf of the test
results within the diseased patients. At the meta-analytic level,
the model fits the data for both groups and all available cutoffs
over all studies. Based on a parametric model, it provides
estimates of the two cdfs for the two groups across all studies,
accounting for the between-study heterogeneity and correlation
between groups.

Users have the choice between the normal (argument
\code{distr="normal"}) and the logistic distribution (argument
\code{distr="logistic"} which is the default). In addition, it is
possible to log-transform the cutoffs (argument \code{log.cutoff},
default is \code{FALSE}).

The cdf, transformed using the quantile function of the chosen
distribution, is modelled by one of eight mixed linear models
("DIDS", "CIDS", "DICS", "CICS", "DS", "CS", "DI", "CI") as
described in Steinhauser et al. (2016).  The argument
\code{equalvar} indicates if the variances of the biomarker in both
groups are assumed to be equal (equalvar = TRUE) or unequal
(equalvar = FALSE).

The pooled sensitivity and specificity values can be obtained at
every cutoff; a multiple cutoffs summary ROC (sROC) naturally
follows while preserving cutoff information. The optimal cutoff is
defined as the cutoff where the maximum of a weighted sum of
sensitivity and specificity is obtained: lambda * sensitivity + (1
- lambda) * specificity. The 95\% confidence intervals of
sensitivities, specificities and the optimal cutoff are estimated
using the delta method (Steinhauser et al., 2016).
}
\examples{
# FENO dataset
#
data(Schneider2017)

diag1 <- diagmeta(tpos, fpos, tneg, fneg, cutpoint,
                  studlab = paste(author, year, group),
                  data = Schneider2017,
                  log.cutoff = TRUE)
                  
summary(diag1)
plot(diag1)

}
\references{
Steinhauser S, Schumacher M, Rücker G (2016):
Modelling multiple thresholds in meta-analysis of diagnostic test
accuracy studies.
\emph{BMC Medical Research Methodology},
\bold{16}, 97
}
\seealso{
\code{\link{plot.diagmeta}, \link{summary.diagmeta}}
}
\author{
Gerta Rücker \email{ruecker@imbi.uni-freiburg.de},
Susanne Steinhauser \email{susanne.steinhauser@uni-koeln.de},
Srinath Kolampally \email{kolampal@imbi.uni-freiburg.de},
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
