% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_num_comp.R
\name{num_comp}
\alias{num_comp}
\alias{num_terms}
\title{Number of new features}
\usage{
num_comp(range = c(1L, unknown()), trans = NULL)

num_terms(range = c(1L, unknown()), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
The number of derived predictors from models or feature engineering methods.
}
\details{
Since the scale of these parameters often depends on the number of columns
in the data set, the upper bound is set to \code{unknown}. For example, the
number of PCA components is limited by the number of columns and so on.

The difference between \code{num_comp()} and \code{num_terms()} is semantics.
}
\examples{
num_terms()
num_terms(c(2L, 10L))
}
