\name{diamond.randwalk}
\alias{diamond.randwalk}
\title{Coordinates of hierarchical random walk}
\description{
  Creates \code{x} and \code{y} coordinates of paths connecting
  centers, in random hierarchical order, of a diamond partition,
  suitable for \code{\link{lines}}.
}
\usage{
  diamond.randwalk (b, d)
}
\arguments{
  \item{b}{list of coordinates of vertices of a diamond, as from 
    \code{\link{diamond.base}}}
  \item{d}{depth of recursion of partition; if \code{d=1},
    then no partition}
}
\details{
  The walk connects diamonds in the partition in the order of the
  labels generated by \code{\link{diamond.labels}}, except that,
  at each hierarchical level, the four elements are randomly permuted.
}
\value{
  List with \code{x} and \code{y} components.
}
\author{Denis White, \email{white.denis@epa.gov} }
\seealso{
  \code{\link{diamond.randlabels}},
  \code{\link{diamond.hierwalk}}
}
\examples{
  base <- diamond.base ()
  diamond.plot (diamond.edges (base, 1))
  points (diamond.centers (base, 4), pch=19, col="red")
  lines (diamond.randwalk (base, 4), lwd=1, col="blue")
  lines (diamond.edges (base, 1), lwd=2, col="black")
  title ("Hierarchical Random Walk at Level 4", line=0)
}
\keyword{dplot}
