\name{diamond.hierwalk}
\alias{diamond.hierwalk}
\title{Coordinates of hierarchical walk}
\description{
  Creates \code{x} and \code{y} coordinates of paths connecting
  centers, in hierarchical order, of a diamond partition, suitable
  for \code{\link{lines}}.
}
\usage{
  diamond.hierwalk (b, d)
}
\arguments{
  \item{b}{list of coordinates of vertices of a diamond, as from 
    \code{\link{diamond.base}}}
  \item{d}{depth of recursion of partition; if \code{d=1},
    then no partition}
}
\details{
  The walk connects diamonds in the partition in the order of the
  labels generated by \code{\link{diamond.labels}}.  That is, the
  walk describes the Morton or Peano sequence of traverse across the
  partition.
}
\value{
  List with \code{x} and \code{y} components.
}
\author{Denis White, \email{white.denis@epa.gov} }
\seealso{
  \code{\link{diamond.labels}},
  \code{\link{diamond.randwalk}}
}
\examples{
  base <- diamond.base ()
  diamond.plot (diamond.edges (base, 1))
  points (diamond.centers (base, 4), pch=19, col="red")
  lines (diamond.hierwalk (base, 4), lwd=1, col="blue")
  lines (diamond.edges (base, 1), lwd=2, col="black")
  title ("Hierarchical Walk at Level 4", line=0)
}
\keyword{dplot}
