% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diat_disp.R
\encoding{UTF-8}
\name{diat_disp}
\alias{diat_disp}
\title{Calculates the Diatom Index for Soda Pans (DISP)}
\usage{
diat_disp(resultLoad, maxDistTaxa = 2)
}
\arguments{
\item{resultLoad}{The resulting list obtained from the diat_loadData() function}

\item{maxDistTaxa}{Integer. Number of characters that can differ in the species' names when compared to the internal database's name in the heuristic search. Default = 2}
}
\description{
The input for all of these functions is the resulting dataframe (resultLoad) obtained from the diat_loadData() function
A CSV or dataframe cannot be used directly with these functions, they have to be loaded first with the diat_loadData() function
so the acronyms and species' names are recognized
References for the index:
\itemize{
\item Stenger-Kovács, C., Körmendi, K., Lengyel, E., Abonyi, A., Hajnal, É., Szabó, B., Buczkó, K. & Padisák, J. (2018). Expanding the trait-based concept of benthic diatoms: Development of trait-and species-based indices for conductivity as the master variable of ecological status in continental saline lakes. Ecological Indicators, 95, 63-74.
}

Sample data in the examples is taken from:
\itemize{
\item Nicolosi Gelis, María Mercedes; Cochero, Joaquín; Donadelli, Jorge; Gómez, Nora. 2020. "Exploring the use of nuclear alterations, motility and ecological guilds in epipelic diatoms as biomonitoring tools for water quality improvement in urban impacted lowland streams". Ecological Indicators, 110, 105951. https://doi:10.1016/j.ecolind.2019.105951
}
}
\examples{
\donttest{
# Example using sample data included in the package (sampleData):
data("diat_sampleData")
# First, the diat_loadData() function has to be called to read the data
# The data will be stored into a list (loadedData)
# And an output folder will be selected through a dialog box if resultsPath is empty
# In the example, a temporary directory will be used in resultsPath
df <- diat_loadData(diat_sampleData, resultsPath = tempdir())
dispResults <- diat_disp(df)
}
}
\keyword{bioindicator}
\keyword{biotic}
\keyword{diatom}
\keyword{ecology}
