% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensus_funs.R
\name{majority_voting}
\alias{majority_voting}
\title{Majority voting}
\usage{
majority_voting(E, is.relabelled = TRUE)
}
\arguments{
\item{E}{a matrix of clusterings with number of rows equal to the number of
cases to be clustered, number of columns equal to the clustering obtained by
different resampling of the data, and the third dimension are the different
algorithms. Matrix may already be two-dimensional.}

\item{is.relabelled}{logical; if \code{FALSE} the data will be relabelled
using the first clustering as the reference.}
}
\value{
a vector of cluster assignments based on majority voting
}
\description{
Combine clustering results using majority voting.
}
\details{
Combine clustering results generated using different algorithms and
different data perturbations by majority voting. The class of a sample is
the cluster label which was selected most often across algorithms and
subsamples.
}
\examples{
data(hgsc)
dat <- hgsc[1:100, 1:50]
cc <- consensus_cluster(dat, nk = 4, reps = 6, algorithms = "pam", progress =
FALSE)
table(majority_voting(cc[, , 1, 1, drop = FALSE], is.relabelled = FALSE))
}
\seealso{
Other consensus functions: \code{\link{CSPA}},
  \code{\link{LCE}}, \code{\link{k_modes}}
}
\author{
Aline Talhouk
}
