% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{PCA-class}
\alias{PCA-class}
\alias{.PCA}
\alias{BootstrapPCA-class}
\alias{.BootstrapPCA}
\title{PCA Results}
\description{
An S4 class to store the results of a principal components analysis.
}
\section{Slots}{

\describe{
\item{\code{center}}{A \code{\link{numeric}} vector giving the column mean of the initial
dataset (active individuals only).}

\item{\code{scale}}{A \code{\link{numeric}} vector giving the column standard deviations of the
initial dataset (active individuals only).}
}}

\examples{
## Load data
data("compiegne", package = "folio")

## Compute principal components analysis
X <- pca(compiegne, scale = TRUE, sup_col = 7:10)

## Get row coordinates
get_coordinates(X, margin = 1)

## Get column coordinates
get_coordinates(X, margin = 2)

## Get row contributions
get_contributions(X, margin = 1)

## Get correlations between variables and dimensions
get_correlations(X)

## Get eigenvalues
get_eigenvalues(X)
}
\seealso{
Other class: 
\code{\link{CA-class}},
\code{\link{MultivariateAnalysis}},
\code{\link{MultivariateBootstrap}},
\code{\link{MultivariateResults}},
\code{\link{MultivariateSummary}}
}
\author{
N. Frerebeau
}
\concept{class}
