% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{PCA-class}
\alias{PCA-class}
\alias{.PCA}
\alias{BootstrapPCA-class}
\alias{.BootstrapPCA}
\title{PCA Results}
\description{
An S4 class to store the results of a principal components analysis.
}
\section{Slots}{

\describe{
\item{\code{center}}{A \code{\link{numeric}} vector giving the column mean of the initial
dataset (active individuals only).}

\item{\code{scale}}{A \code{\link{numeric}} vector giving the column standard deviations of the
initial dataset (active individuals only).}
}}

\examples{
## Load data
data("iris")

## Compute principal components analysis
X <- pca(iris, scale = TRUE, sup_row = sample(150, 10), sup_col = 2)

## Get row coordinates
head(get_coordinates(X, margin = 1))

## Get column coordinates
head(get_coordinates(X, margin = 2))

## Get row contributions
head(get_contributions(X, margin = 1))

## Get correlations between variables and dimensions
head(get_correlations(X))

## Get eigenvalues
get_eigenvalues(X)
}
\seealso{
Other class: 
\code{\link{CA-class}},
\code{\link{MultivariateAnalysis}},
\code{\link{MultivariateBootstrap}},
\code{\link{MultivariateResults}},
\code{\link{MultivariateSummary}}
}
\author{
N. Frerebeau
}
\concept{class}
