% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{palette_color}
\alias{palette_color}
\title{Color Mapping}
\usage{
palette_color(
  colors = NULL,
  domain = NULL,
  midpoint = NULL,
  ordered = FALSE,
  missing = "#DDDDDD",
  ...
)
}
\arguments{
\item{colors}{A vector of colors that values will be mapped to.}

\item{domain}{A \code{\link{numeric}} range or a vector of categorical data specifying
the possible values that can be mapped.}

\item{midpoint}{A length-one \code{\link{numeric}} vector specifying the mid-point of
input range.}

\item{ordered}{A \code{\link{logical}} scalar: should the levels be treated as already
in the correct order?}

\item{missing}{The color to return for \code{NA} values.}

\item{...}{Further parameters to be passed to internal methods.}
}
\value{
A palette \code{\link{function}} that when called with a single argument returns
a \code{\link{character}} vector of colors.
}
\description{
Maps values to a colors.
}
\details{
A wrapper around \code{palette_color_continuous()} and
\code{palette_color_discrete()}.
}
\seealso{
Other palettes: 
\code{\link{palette_color_continuous}()},
\code{\link{palette_color_discrete}()},
\code{\link{palette_shape}()},
\code{\link{palette_size_range}()}
}
\concept{palettes}
\keyword{internal}
