% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svd.R
\name{svd2}
\alias{svd2}
\title{Singular Value Decomposition of a Matrix}
\usage{
svd2(x, rank = Inf)
}
\arguments{
\item{x}{A \eqn{m \times p}{m x p} numeric \code{\link{matrix}}.}

\item{rank}{An \code{\link{integer}} value specifying the maximal number of components
to be kept in the results.}
}
\value{
A \code{\link{list}} with the following elements:
\describe{
\item{\code{d}}{A vector containing the singular values of \code{x}, of length
\code{rank}, sorted decreasingly.}
\item{\code{u}}{A matrix whose columns contain the left singular vectors of
\code{x}. Dimension \code{c(m, rank)}.}
\item{\code{v}}{A matrix whose columns contain the right singular vectors of
\code{x}. Dimension \code{c(p, rank)}.}
}
}
\description{
Singular Value Decomposition of a Matrix
}
\note{
In both PCA and PCA-cor whitening there is a sign-ambiguity in the
eigenvector matrices. In order to resolve the sign-ambiguity we use
eigenvector matrices with a positive diagonal. This has the effect to make
cross-correlations and cross-correlations positive diagonal for PCA.
}
\keyword{internal}
